using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public class DataProvider
{
    /// <summary>
    /// Provide items to paged ObjectDataSource
    /// </summary>
    /// <param name="StartIndex"></param>
    /// <param name="Number"></param>
    /// <returns></returns>
    public List<TheItem> Provide( int StartIndex, int Number )
    {
        return TheModel.Items.GetRange( StartIndex, Number );
    }

    /// <summary>
    /// Provide specific item
    /// </summary>
    /// <param name="ID"></param>
    /// <returns></returns>
    public TheItem Provide( int ID )
    {
        // the implementation is for demo purposes only
        for ( int i = 0; i < TheModel.Items.Count; i++ )
            if ( TheModel.Items[i].ID == ID )
                return TheModel.Items[i];

        return null;
    }

    /// <summary>
    /// Provide items count for ObjectDataSource
    /// </summary>
    /// <returns></returns>
    public int Count()
    {
        return TheModel.Items.Count;
    }

	public DataProvider()
	{
	}
}
