using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.ComponentModel;

namespace Application.Web.UI.Controls
{
    [ValidationProperty("Text")]
    public class SelectableTextBox : WebControl, INamingContainer
    {
        public SelectableTextBox() { }

        private TextBox KeyTextBox;
        private HiddenField ValueTextBox;
        private RequiredFieldValidator RequiredValidatorKeyTextBox;

        #region Static helper
        const string ClientReturnScript =
        "window.opener.document.getElementById( '{0}' ).value = '{1}';\r\n" +
        "window.opener.document.getElementById( '{2}' ).value = '{3}';\r\n" +
        "window.close();";
        public static void ReturnKeyAndValue(Page Page, string Key, string Value)
        {
            string Script =
                string.Format(
                    ClientReturnScript,
                    Page.Request.QueryString["keyControlID"],
                    Key,
                    Page.Request.QueryString["valueControlID"],
                    Value);

            Page.ClientScript.RegisterStartupScript(typeof(SelectableTextBox), "clientreturnscript", "<script>" + Script + "</script>");
        }
        #endregion

        #region Properties

        private bool allowClear = false;
        [Browsable(true), Category("Appearance")]
        public bool AllowClear
        {
            get
            {
                return allowClear;
            }
            set
            {
                allowClear = value;
            }
        }

        private string selectItemCaption = "Przywoanie okna wyboru elementu";
        [Browsable(true), Category("Appearance")]
        public string SelectItemCaption
        {
            get
            {
                return selectItemCaption;
            }
            set
            {
                selectItemCaption = value;
            }
        }

        private string clearItemCaption = "Czyszczenie pola wyboru elementu";
        [Browsable(true), Category("Appearance")]
        public string ClearItemCaption
        {
            get
            {
                return clearItemCaption;
            }
            set
            {
                clearItemCaption = value;
            }
        }

        private string clientUrl;
        [Browsable(true), Category("Action")]
        public string ClientUrl
        {
            get
            {
                return TildaHandler(clientUrl);
            }
            set
            {
                clientUrl = value;
            }
        }

        private int clientWindowWidth = 800;
        [Browsable(true), Category("Appearance")]
        public int ClientWindowWidth
        {
            get
            {
                return clientWindowWidth;
            }
            set
            {
                clientWindowWidth = value;
            }
        }

        private int clientWindowHeight = 600;
        [Browsable(true), Category("Appearance")]
        public int ClientWindowHeight
        {
            get
            {
                return clientWindowHeight;
            }
            set
            {
                clientWindowHeight = value;
            }
        }

        private int clientWindowLeft = 100;
        [Browsable(true), Category("Appearance")]
        public int ClientWindowLeft
        {
            get
            {
                return clientWindowLeft;
            }
            set
            {
                clientWindowLeft = value;
            }
        }

        private int clientWindowTop = 100;
        [Browsable(true), Category("Appearance")]
        public int ClientWindowTop
        {
            get
            {
                return clientWindowTop;
            }
            set
            {
                clientWindowTop = value;
            }
        }

        private ButtonType buttonType;
        [Browsable(true), Category("Appearance")]
        public ButtonType ButtonType
        {
            get
            {
                EnsureChildControls();
                return buttonType;
            }
            set
            {
                EnsureChildControls();
                buttonType = value;
            }
        }

        #region RequiredValidator
        bool requiredValidator = false;
        [Browsable(true), Category("Action")]
        public bool RequiredValidator
        {
            get
            {
                return requiredValidator;
            }
            set
            {
                requiredValidator = value;
                if (value)
                {

                    RequiredValidatorKeyTextBox.ID = "RequiredValidatorKeyTextBox";
                    RequiredValidatorKeyTextBox.ControlToValidate = KeyTextBox.ID;

                    this.Controls.Add(RequiredValidatorKeyTextBox);
                }
            }
        }

        [Browsable(true), Category("Action")]
        public string RequiredValidatorErrorMessage
        {
            get
            {
                return RequiredValidatorKeyTextBox.ErrorMessage;
            }
            set
            {
                RequiredValidatorKeyTextBox.ErrorMessage = value;
            }
        }

        [Browsable(true), Category("Action")]
        public ValidatorDisplay RequiredValidatorDisplay
        {
            get
            {
                return RequiredValidatorKeyTextBox.Display;
            }
            set
            {
                RequiredValidatorKeyTextBox.Display = value;
            }
        }

        [Browsable(true), Category("Action")]
        public string RequiredValidatorValidationGroup
        {
            get
            {
                return RequiredValidatorKeyTextBox.ValidationGroup;
            }
            set
            {
                RequiredValidatorKeyTextBox.ValidationGroup = value;
            }
        }
        #endregion

        #region Button
        private string buttonCaption;
        [Browsable(true), Category("Appearance")]
        public string ButtonCaption
        {
            get
            {
                EnsureChildControls();
                return buttonCaption;
            }
            set
            {
                EnsureChildControls();
                buttonCaption = value;
            }
        }

        private string clearButtonCaption;
        [Browsable(true), Category("Appearance")]
        public string ClearButtonCaption
        {
            get
            {
                EnsureChildControls();
                return clearButtonCaption;
            }
            set
            {
                EnsureChildControls();
                clearButtonCaption = value;
            }
        }
        #endregion

        #region Image Button
        private string imageUrl;
        [Browsable(true), Category("Appearance")]
        public string ImageUrl
        {
            get
            {
                EnsureChildControls();

                return TildaHandler(imageUrl);
            }
            set
            {
                EnsureChildControls();
                imageUrl = value;
            }
        }

        private string clearImageUrl;
        [Browsable(true), Category("Appearance")]
        public string ClearImageUrl
        {
            get
            {
                EnsureChildControls();

                return TildaHandler(clearImageUrl);
            }
            set
            {
                EnsureChildControls();
                clearImageUrl = value;
            }
        }
        #endregion

        #endregion

        #region Client properties

        [Browsable(false), Bindable(true)]
        public string Text
        {
            get
            {
                return KeyTextBox.Text;
            }
            set
            {
                KeyTextBox.Text = value;
            }
        }

        [Browsable(false)]
        public string SelectedValue
        {
            get
            {
                if (!string.IsNullOrEmpty(ValueTextBox.Value))
                    return ValueTextBox.Value;

                return null;
            }
            set
            {
                ValueTextBox.Value = value;
            }
        }

        public override ControlCollection Controls
        {
            get
            {
                EnsureChildControls();
                return base.Controls;
            }
        }


        #endregion

        protected override void CreateChildControls()
        {
            KeyTextBox = new TextBox();
            KeyTextBox.ID = "KeyTextBox";
            KeyTextBox.Width = new Unit(100, UnitType.Percentage);
            KeyTextBox.Style.Add("padding", "0");


            ValueTextBox = new HiddenField();
            ValueTextBox.ID = "ValueTextBox";

            this.Controls.Add(KeyTextBox);
            this.Controls.Add(ValueTextBox);

            RequiredValidatorKeyTextBox = new RequiredFieldValidator();



        }

        string Script =
        "<script>\r\n" +
        "function showWindowForSelectableControl(address, width, height, left, top, keyControlID, valueControlID) \r\n" +
        "{ \r\n " +
        "  noweOkno = window.open( address + '?keyControlID='+keyControlID+'&valueControlID=' + valueControlID, '_blank', 'menubar=no, toolbar=no, location=no, scrollbars=yes, resizable=yes, status=no, width='+width+', height='+height+', left='+left+', top='+top); \r\n" +
        "  noweOkno.focus(); \r\n" +
        "}\r\n</script>";
        string ClearSelectionScript =
        "<script>\r\n" +
        "function clearSelectionForSelectableControl(keyControlID, valueControlID) \r\n" +
        "{ \r\n " +
        "  document.getElementById(keyControlID).value = ''; \r\n" +
        "  document.getElementById(valueControlID).value = ''; \r\n" +
        "}\r\n</script>";
        string MakeControlReadOnlyScript =
        "<script>\r\n" +
        "function makeControlReadOnly(keyControlID) \r\n" +
        "{ \r\n " +
        "  formant = document.getElementById(keyControlID); \r\n" +
        "  if ( formant != null && formant.readOnly != null ) formant.readOnly = true; \r\n" +
        "}\r\n</script>";

        protected override void OnLoad(EventArgs e)
        {
            EnsureChildControls();

            // skrypty 
            this.Page.ClientScript.RegisterStartupScript( typeof( SelectableTextBox ), "showWindowFunction", Script );
            this.Page.ClientScript.RegisterStartupScript( typeof( SelectableTextBox ), "clearSelectionFunction", ClearSelectionScript );

            this.Page.ClientScript.RegisterStartupScript( typeof( SelectableTextBox ), "readOnlyFunction", MakeControlReadOnlyScript );
            this.Page.ClientScript.RegisterStartupScript( typeof( SelectableTextBox ), KeyTextBox.ClientID, string.Format( "<script>makeControlReadOnly('{0}')</script>", KeyTextBox.ClientID ) );

        }

        protected override void Render(HtmlTextWriter writer)
        {
            // Make sure this control is in a server form.
            if (Page != null)
            {
                Page.VerifyRenderingInServerForm(this);
            }

            //AddAttributesToRender( writer );


            writer.AddAttribute(HtmlTextWriterAttribute.Width, requiredValidator ? "100%" : this.Width.ToString());
            writer.AddAttribute(HtmlTextWriterAttribute.Border, "0");
            writer.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "0");
            writer.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "0");

            if (!string.IsNullOrEmpty(this.CssClass))
                writer.AddAttribute(HtmlTextWriterAttribute.Class, this.CssClass);

            writer.RenderBeginTag(HtmlTextWriterTag.Table);

            // writer.WriteBeginTag( "table" );
            // writer.WriteAttribute( "border", "0" );
            // writer.WriteAttribute( "cellpadding", "0" );
            // writer.WriteAttribute( "cellspacing", "0" );
            // writer.WriteAttribute("width", "100%");
            // writer.Write( ">" );

            writer.WriteBeginTag("tr");
            writer.Write(">");

            // pola tekstowe
            writer.WriteBeginTag("td");
            writer.WriteAttribute("width", requiredValidator ? this.Width.ToString() : "100%");
            writer.WriteAttribute("style", "padding-right : 8px");
            writer.Write(">");

            KeyTextBox.RenderControl(writer);
            ValueTextBox.RenderControl(writer);

            writer.WriteEndTag("td");

            // przycisk wyboru
            writer.WriteBeginTag("td");
            writer.Write(">");
            string ClientScript =
                string.Format("showWindowForSelectableControl( '{0}', {1}, {2}, {3}, {4}, '{5}', '{6}' )",
                    ClientUrl,
                    ClientWindowWidth, ClientWindowHeight,
                    ClientWindowLeft, ClientWindowTop,
                    KeyTextBox.ClientID, ValueTextBox.ClientID);

            switch (this.ButtonType)
            {
                case ButtonType.Image:
                    writer.WriteBeginTag("image");
                    writer.WriteAttribute("alt", string.Empty);
                    writer.WriteAttribute("src", ImageUrl);
                    writer.WriteAttribute("onclick", ClientScript);
                    writer.WriteAttribute("title", SelectItemCaption);
                    writer.WriteAttribute("style", "cursor: pointer");
                    writer.Write(">");
                    writer.WriteEndTag("image");
                    break;
                case ButtonType.Link:
                    writer.WriteBeginTag("a");
                    writer.WriteAttribute("href", "#");
                    writer.WriteAttribute("onclick", ClientScript);
                    writer.WriteAttribute("title", SelectItemCaption);
                    writer.Write(">");
                    writer.Write(ButtonCaption);
                    writer.WriteEndTag("a");
                    break;
                default:
                    writer.WriteBeginTag("button");
                    writer.WriteAttribute("onclick", ClientScript);
                    writer.WriteAttribute("title", SelectItemCaption);
                    writer.Write(">");
                    writer.Write(ButtonCaption);
                    writer.WriteEndTag("button");
                    break;
            }
            writer.WriteEndTag("td");

            // przycisk czyszczenia
            if (AllowClear)
            {
                writer.WriteBeginTag("td");
                writer.WriteAttribute("style", "padding-left : 4px");
                writer.Write(">");

                string ClearClientScript =
                    string.Format("clearSelectionForSelectableControl( '{0}', '{1}' )",
                        KeyTextBox.ClientID, ValueTextBox.ClientID);

                switch (this.ButtonType)
                {
                    case ButtonType.Image:
                        writer.WriteBeginTag("image");
                        writer.WriteAttribute("alt", string.Empty);
                        writer.WriteAttribute("src", ClearImageUrl);
                        writer.WriteAttribute("onclick", ClearClientScript);
                        writer.WriteAttribute("title", ClearItemCaption);
                        writer.WriteAttribute("style", "cursor: pointer");
                        writer.Write(">");
                        writer.WriteEndTag("image");
                        break;
                    case ButtonType.Link:
                        writer.WriteBeginTag("a");
                        writer.WriteAttribute("href", "#");
                        writer.WriteAttribute("onclick", ClearClientScript);
                        writer.WriteAttribute("title", ClearItemCaption);
                        writer.Write(">");
                        writer.Write(ClearButtonCaption);
                        writer.WriteEndTag("a");
                        break;
                    default:
                        writer.WriteBeginTag("button");
                        writer.WriteAttribute("onclick", ClearClientScript);
                        writer.WriteAttribute("title", ClearItemCaption);
                        writer.Write(">");
                        writer.Write(ClearButtonCaption);
                        writer.WriteEndTag("button");
                        break;
                }

                writer.WriteEndTag("td");
            }

            if (requiredValidator)
            {
                // RequiredValidatorKeyTextBox
                writer.WriteBeginTag("td");
                writer.WriteAttribute("width", "100%");
                writer.WriteAttribute("style", "padding-left : 4px");
                writer.Write(">");

                RequiredValidatorKeyTextBox.RenderControl(writer);
                writer.WriteEndTag("td");

            }
            writer.WriteEndTag("tr");
            //   writer.WriteEndTag( "table" );

            writer.RenderEndTag();

        }

        string TildaHandler(string Url)
        {
            return base.ResolveUrl(Url);
        }


    }
}