using System;
using System.Drawing;
using System.Windows.Forms;

namespace UniversalGrabber
{
	public class CPictureBox : PictureBox
	{
		public  Image pImage = null;
		public  Point pStart, pEnd;

		public CPictureBox()
		{
			SetStyle(ControlStyles.UserPaint, true);
			SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			SetStyle(ControlStyles.DoubleBuffer, true);
		}

		protected override void OnPaint( PaintEventArgs e )
		{
			base.OnPaint( e );
			if ( pStart != Point.Empty && pEnd != Point.Empty )
				e.Graphics.DrawRectangle( Pens.Red, CVaria.RectFromPoints( pStart, pEnd ) );
		}
		
		protected override void OnMouseDown( MouseEventArgs e )
		{
			if ( this.Image != null )
				pStart = pEnd  = new Point( e.X, e.Y );
		}

		protected override void OnMouseUp( MouseEventArgs e )
		{
			if ( this.Cursor != Cursors.Default )
				this.Cursor = Cursors.Default;
		}

		protected override void OnMouseMove( MouseEventArgs e )
		{
			if ( this.Image != null && e.Button == MouseButtons.Left )
			{
				if ( this.Cursor != Cursors.Cross ) 
					this.Cursor = Cursors.Cross;
				pEnd = new Point( e.X, e.Y );
				this.Invalidate();
			}
		}

		public void Reset()
		{
			pStart = pEnd  = Point.Empty;
			this.Invalidate();
		}
	}
}
