using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Vulcan.Uczniowie.HelpProvider
{
    public class ControlHelper
    {
        #region Control ID
        public static string GetControlID( Control Control )
        {
            if ( Control is Form ||
                 Control.Parent == null
                )
                return Control.GetType().FullName;
            else

                return string.Format( "{0}/{1}", GetControlID( Control.Parent ), Control.Name );
        }

        public static string[] GetControlIDPath( Control Control )
        {
            return GetControlIDPath( GetControlID( Control ) );
        }

        public static string[] GetControlIDPath( string ControlID )
        {
            return ControlID.Split( '/' );
        }

        public static List<Control> GetControlTree( Control Control )
        {
            List<Control> ret = new List<Control>();

            ret = GetControlTree( Control, ret );
            ret.Reverse();

            return ret;
        }

        private static List<Control> GetControlTree( Control Control, List<Control> ret )
        {
            if ( Control == null )
                return ret;

            ret.Add( Control );
            return GetControlTree( Control.Parent, ret );
        }

        public static string GetControlDescription( Control Control )
        {
            if ( Control == null ) return "[pusty]";

            if ( Control is Form )
                return string.Format( "{0}", Control.GetType().FullName );
            else
                return string.Format( "{0} [{1}]", Control.Name, Control.GetType().Name );
        }
        #endregion
    }
}
