using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Vulcan.Uczniowie.HelpProvider
{
    public partial class HelpEditor : Form
    {
        #region Konstrukcja, skadowe
        private HelpEditor() { }
        public HelpEditor( Control Control )
        {
            InitializeComponent();

            InitializeControls();
            InitializePath();
            InitializeTreeForControl( Control );
        }

        private void InitializeControls()
        {
            foreach ( HelpNavigator v in Enum.GetValues( typeof( HelpNavigator ) ) )
                cbNavigator.Items.Add( v );
            cbNavigator.SelectedItem = HelpNavigator.Topic;
        }

        private HelpDescription HelpDescription = ResourceHelper.HelpDescription;
        #endregion

        #region Logika
        private void InitializePath()
        {
            txtHelpFile.Text = HelpDescription.HelpFile;
        }

        private void InitializeTreeForControl( Control Control )
        {
            string ControlId = ControlHelper.GetControlID( Control );
            string[] ControlIdParts = ControlHelper.GetControlIDPath( ControlId );

            List<Control> ControlTree = ControlHelper.GetControlTree( Control );

            TreeNode Node  = null;
            foreach ( Control c in ControlTree )
            {
                TreeNode CNode  = new TreeNode( ControlHelper.GetControlDescription( c ) );
                CNode.Tag       = c;

                SetNodeProperties( CNode );

                if ( Node == null )
                    tvNodes.Nodes.Add( CNode );
                else
                    Node.Nodes.Add( CNode );                    

                Node = CNode;
            }

            tvNodes.ExpandAll();
        }

        private void SetNodeProperties( TreeNode Node )
        {
            if ( Node.Tag is Control )
            {
                ControlHelpDescription ExactDescription = HelpDescription.FindExactDescription( Node.Tag as Control );
                Node.ForeColor =
                    ExactDescription == null ||
                    string.IsNullOrEmpty( ExactDescription.HelpKeyword ) ?
                    Color.Red : SystemColors.WindowText;
            }
        }

        private void InitializeDescriptionForControl( Control Control )
        {
            ControlHelpDescription Description = HelpDescription.FindExactDescription( Control );

            if ( Description != null )
            {
                txtCategory.Text = Description.HelpKeyword;
                cbNavigator.SelectedItem = Description.HelpNavigator;
                cbShowHelp.Checked = Description.ShowHelp;
            }
            else
            {
                txtCategory.Text = string.Empty;
                cbNavigator.SelectedItem = HelpNavigator.Topic;
                cbShowHelp.Checked = true;
            }
        }
        #endregion

        #region  Obsuga logiki formantw

        private void txtHelpFile_Validated( object sender, EventArgs e )
        {
            HelpDescription.HelpFile = txtHelpFile.Text;
        }

        private void txtCategory_Validated( object sender, EventArgs e )
        {
            if ( SelectedDescription != null )
                SelectedDescription.HelpKeyword = txtCategory.Text;
            SetNodeProperties( tvNodes.SelectedNode );
        }

        private void cbNavigator_Validated( object sender, EventArgs e )
        {
            if ( SelectedDescription != null )
                SelectedDescription.HelpNavigator = (HelpNavigator)cbNavigator.SelectedItem;
            SetNodeProperties( tvNodes.SelectedNode );
        }

        private void cbShowHelp_Validated( object sender, EventArgs e )
        {
            if ( SelectedDescription != null )
                SelectedDescription.ShowHelp = cbShowHelp.Checked;
            SetNodeProperties( tvNodes.SelectedNode );
        }

        private ControlHelpDescription SelectedDescription
        {
            get
            {
                if ( tvNodes.SelectedNode.Tag is Control )
                {
                    Control Control = tvNodes.SelectedNode.Tag as Control;
                    return HelpDescription.CreateExactDescription( Control );
                }

                return null;
            }
        }

        private void btSave_Click( object sender, EventArgs e )
        {
            try
            {
                ResourceHelper.SaveHelpDescription( HelpDescription );
                Close();
            }
            catch ( Exception ex )
            {
                MessageBox.Show( "Bd zapisu mapowania pomocy.\r\n\r\n" + ex.Message, "Bd", MessageBoxButtons.OK, MessageBoxIcon.Error );
            }
        }

        private void tvNodes_AfterSelect( object sender, TreeViewEventArgs e )
        {
            if ( e.Node.Tag is Control )
            {
                gbProperties.Enabled = true;
                InitializeDescriptionForControl( e.Node.Tag as Control );
            }
            else
                gbProperties.Enabled = false;
        }
        #endregion
    }
}