using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace Vulcan.Uczniowie.HelpProvider
{
    [XmlRoot( "XmlHelp", Namespace="http://vulcan.edu.pl/HelpDescription" )]
    public class HelpDescription
    {
        [XmlAttribute( "HelpFile" )]
        public string HelpFile;

        [XmlElement( "Control", typeof( ControlHelpDescription ) )]
        public List<ControlHelpDescription> TopicDescription = new List<ControlHelpDescription>();

        #region Public properties
        public string HelpFilePath
        {
            get
            {
                return Path.Combine( Application.StartupPath, HelpFile );
            }
        }
        #endregion

        #region Description
        public ControlHelpDescription CreateExactDescription( Control Control )
        {
            return CreateExactDescription( ControlHelper.GetControlIDPath( Control ) );
        }

        public ControlHelpDescription CreateExactDescription( string[] ControlPath )
        {
            ControlHelpDescription Description = FindExactDescription( ControlPath );

            if ( Description == null )
                return CreateExactDescription( TopicDescription, ControlPath );
            
            return Description;
        }

        private ControlHelpDescription CreateExactDescription( List<ControlHelpDescription> TopicDescription, string[] ControlPath )
        {
            ControlHelpDescription ChildDescription = null;
            // szukaj opisu pasujcego do prefiksu opisu
            foreach ( ControlHelpDescription Description in TopicDescription )
                if ( Description.Name == ControlPath[0] )
                    ChildDescription = Description;
            // jeli nie znaleziono to twrz
            if ( ChildDescription == null )
            {
                ChildDescription = new ControlHelpDescription();
                ChildDescription.Name = ControlPath[0];

                TopicDescription.Add( ChildDescription );
            }
            // rekursja
            if ( ControlPath.Length > 1 )
                return CreateExactDescription( ChildDescription.TopicDescription, (string[])ArrayHelper.CreateSubArray( ControlPath, 1, ControlPath.Length - 1 ) );
            else
                return ChildDescription;
        }

        public ControlHelpDescription FindExactDescription( Control Control )
        {
            return FindExactDescription( ControlHelper.GetControlIDPath( Control ) );
        }

        public ControlHelpDescription FindExactDescription( string[] ControlPath )
        {
            return FindExactDescription( TopicDescription, ControlPath );
        }

        private ControlHelpDescription FindExactDescription( List<ControlHelpDescription> TopicDescription, string[] ControlPath )
        {
            if ( ControlPath.Length > 0 )
            {
                foreach ( ControlHelpDescription Description in TopicDescription )
                    if ( Description.Name == ControlPath[0] )
                    {
                        if ( ControlPath.Length == 1 )
                            return Description;
                        else
                            return FindExactDescription( Description.TopicDescription, (string[])ArrayHelper.CreateSubArray( ControlPath, 1, ControlPath.Length - 1 ) );
                    }
            }

            return null;
        }

        public ControlHelpDescription FindDescription( string[] ControlPath )
        {
            return FindDescription( TopicDescription, ControlPath );
        }

        private ControlHelpDescription FindDescription( List<ControlHelpDescription> TopicDescription, string[] ControlPath )
        {
            if ( ControlPath.Length > 0 )
            {
                foreach ( ControlHelpDescription Description in TopicDescription )
                    if ( Description.Name == ControlPath[0] )
                    {
                        ControlHelpDescription ChildDescription = FindDescription( Description.TopicDescription, (string[])ArrayHelper.CreateSubArray( ControlPath, 1, ControlPath.Length - 1 ) );
                        if ( ChildDescription != null )
                            return ChildDescription;
                        else
                            return Description;
                    }
            }

            return null;
        }

        public static HelpDescription Empty
        {
            get
            {
                return new HelpDescription();
            }
        }
        #endregion
    }

    public class ControlHelpDescription
    {
        [XmlAttribute( "Name" )]
        public string Name;
        [XmlAttribute("HelpKeyword")]
        public string HelpKeyword;
        [XmlAttribute( "HelpNavigator" )]
        public HelpNavigator HelpNavigator = HelpNavigator.Topic;
        [XmlAttribute( "ShowHelp" )]
        public bool ShowHelp = true;

        [XmlElement( "Control", typeof( ControlHelpDescription ) )]
        public List<ControlHelpDescription> TopicDescription = new List<ControlHelpDescription>();
    }
}
