using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;
using System.Reflection;

namespace Vulcan.Uczniowie.HelpProvider
{
    public class ClientHelpProcessor : IHelpProcessor
    {
        #region IHelpProcessor Members
        public void ProcessControlHelp( System.Windows.Forms.Control Control )
        {
            string ControlId = ControlHelper.GetControlID( Control );
            string[] ControlIdParts = ControlHelper.GetControlIDPath( ControlId );

            if ( ResourceHelper.HelpDescription != HelpDescription.Empty )
            {
                ControlHelpDescription TopicDescription = ResourceHelper.HelpDescription.FindDescription( ControlIdParts );

                if ( TopicDescription != null )
                {
                    if ( TopicDescription.ShowHelp )
                        Help.ShowHelp( Control, ResourceHelper.HelpDescription.HelpFilePath, TopicDescription.HelpNavigator, TopicDescription.HelpKeyword );
                }
                else
                    if ( !string.IsNullOrEmpty ( ResourceHelper.HelpDescription.HelpFile ) )
                        Help.ShowHelp( Control, ResourceHelper.HelpDescription.HelpFilePath );
            }
        }
        #endregion
    }
}
