using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace WindowsApplication1
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main( string[] args )
        {
            bool IsClickOnce = System.Deployment.Application.ApplicationDeployment.IsNetworkDeployed;
            
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault( false );
            Application.Run( new Form1() );
        }

        public static Dictionary<string, string> UriArgs()
        {
            Dictionary<string, string> nameValueTable = new Dictionary<string, string>();
            if ( System.Deployment.Application.ApplicationDeployment.IsNetworkDeployed )
            {
                string url = System.Deployment.Application.ApplicationDeployment.CurrentDeployment.ActivationUri.AbsoluteUri;
                string queryString = ( new Uri( url ) ).Query;
                if ( queryString != "" )
                {
                    string[] nameValuePairs = queryString.Split( '&' );
                    bool firstVar = true;
                    foreach ( string pair in nameValuePairs )
                    {
                        string[] vars = pair.Split( '=' );
                        if ( firstVar )
                        {
                            firstVar = false;
                            if ( vars[0].Contains( "?" ) )
                            {
                                vars = new string[] { vars[0].Trim( '?' ), vars[1] };
                            }
                        }
                        if ( !nameValueTable.ContainsKey( vars[0] ) )
                        {
                            nameValueTable.Add( vars[0], vars[1] );
                        }
                    }
                }
            }

            return ( nameValueTable );
        }
        
    }
}