using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace FastTetrisXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class FastTetrisGame : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch           spriteBatch;
        SpriteFont            defaultSpriteFont;
        SpriteFont            gameOverSpriteFont;
        Texture2D             blackBlockTexture;
        Board                 board;

        bool gameOver = false;

        double AutoSpeedConst  = 30000; // speedup every 30 sec 
        double AutoSpeed       = 0;      // counter
        double FrameDelayConst = 200;    // frame every 200ms
        double FrameDelayMin   = 20;     // fastest
        double FrameDelayDelta = 15;     // decrement
        double FrameDelay = 0;           // counter

        int Frames = 0;

        public FastTetrisGame()
        {
            this.IsFixedTimeStep = false;

            try
            {
                Window.Title = "torq314tris (c) 2011";

                graphics = new GraphicsDeviceManager( this );

                graphics.PreferredBackBufferWidth = Board.SIZEX * Board.DRAWINGBLOCKSIZE;
                graphics.PreferredBackBufferHeight = Board.SIZEY * Board.DRAWINGBLOCKSIZE;
                graphics.IsFullScreen = false;

                graphics.ApplyChanges();

                Content.RootDirectory = "Content";
            }
            catch ( Exception ex )
            {
                MessageBox( 0, ex.Message, "", 0 );
            }
        }

        [DllImport( "user32.dll", CharSet = CharSet.Auto )]
        public static extern uint MessageBox( int hWnd, String text, String caption, uint type );

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();

            oldState = Keyboard.GetState();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch( GraphicsDevice );

            defaultSpriteFont  = this.Content.Load<SpriteFont>( "DefaultSpriteFont" );
            gameOverSpriteFont = this.Content.Load<SpriteFont>( "GameOverSpriteFont" );
            blackBlockTexture  = TextureHelper.CreateRectangle( GraphicsDevice, Board.DRAWINGBLOCKSIZE, Board.DRAWINGBLOCKSIZE, Color.Black );

            board = new Board( GraphicsDevice );
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
        }

        KeyboardState oldState;
        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update( GameTime gameTime )
        {
            // Allows the game to exit
            KeyboardState state = Keyboard.GetState();

            if ( state.IsKeyDown( Keys.Escape ) )
                this.Exit();

            Frames++;

            Board.PieceMove move = Board.PieceMove.None;
            if ( state.IsKeyDown( Keys.Left ) && !oldState.IsKeyDown( Keys.Left ) )
                move = Board.PieceMove.Left;
            else if ( state.IsKeyDown( Keys.Right ) && !oldState.IsKeyDown( Keys.Right ) )
                move = Board.PieceMove.Right;
            else if ( state.IsKeyDown( Keys.Space ) && !oldState.IsKeyDown( Keys.Space ) )
                move = Board.PieceMove.Rotate;
            else if ( state.IsKeyDown( Keys.Down ) )
                move = Board.PieceMove.Down;

            board.MoveCurrentPiece( move );

            FrameDelay += gameTime.ElapsedGameTime.TotalMilliseconds;
            if ( FrameDelay > FrameDelayConst )
            {
                FrameDelay = 0;
                if ( !board.AutoUpdate() )
                    gameOver = true;
            }

            AutoSpeed += gameTime.ElapsedGameTime.TotalMilliseconds;
            if ( AutoSpeed > AutoSpeedConst )
            {
                if ( FrameDelayConst > FrameDelayMin )
                    FrameDelayConst -= FrameDelayDelta;
                AutoSpeed = 0;
            }

            oldState = state;

            base.Update( gameTime );
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw( GameTime gameTime )
        {
            GraphicsDevice.Clear( Color.White );

            spriteBatch.Begin();

            board.DrawOntoSpriteBatch( spriteBatch, defaultSpriteFont, blackBlockTexture );            
            if ( gameOver )
                DrawGameOver( spriteBatch );

            spriteBatch.End();

            base.Draw( gameTime );
        }

        private void DrawGameOver( SpriteBatch batch )
        {
            string GameOverString  = "Game Over";
            Vector2 PressStartSize = gameOverSpriteFont.MeasureString( GameOverString );

            batch.DrawString( this.gameOverSpriteFont,
                           GameOverString,
                           new Vector2( ( this.graphics.GraphicsDevice.Viewport.Width / 2 ) + 2, ( this.graphics.GraphicsDevice.Viewport.Height / 2 ) + 2 ),
                           Color.Black, 0.0f,
                           new Vector2( PressStartSize.X / 2, PressStartSize.Y / 2 ),
                           1.0f, SpriteEffects.None, 0.0f );

            batch.DrawString( this.gameOverSpriteFont,
                GameOverString,
                new Vector2( this.graphics.GraphicsDevice.Viewport.Width / 2, this.graphics.GraphicsDevice.Viewport.Height / 2 ),
                Color.Red, 0.0f,
                new Vector2( PressStartSize.X / 2, PressStartSize.Y / 2 ),
                1.0f, SpriteEffects.None, 0.0f );
        }

        public double GetFps( TimeSpan ElapsedFromLastFrame )
        {
            if ( ElapsedFromLastFrame.TotalMilliseconds > 0 )
                return 1000.0 / ElapsedFromLastFrame.TotalMilliseconds;
            else
                return 0;
        }
    }
}
