﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FastTetris
{
    public partial class MainForm : Form
    {
       Board TheBoard;

        public MainForm()
        {
            InitializeComponent();

            this.SetStyle( ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint | ControlStyles.OptimizedDoubleBuffer, true );
            this.TheBoard = new Board();
        }

        private void tmr_AutoUpdateGame_Tick( object sender, EventArgs e )
        {
            if ( TheBoard.AutoUpdate() )
                this.Invalidate();
            else
            {
                tmr_AutoUpdateGame.Stop();
                MessageBox.Show( string.Format( "Game over.\r\n\r\nScore {0}", TheBoard.Score ), "Game", MessageBoxButtons.OK, MessageBoxIcon.Information );
            }
        }

        private void tmr_SpeedUpGame_Tick( object sender, EventArgs e )
        {
            if ( tmr_AutoUpdateGame.Interval > 20 )
                tmr_AutoUpdateGame.Interval -= 10;
        }

        protected override void OnPaint( PaintEventArgs e )
        {
            base.OnPaint( e );

            e.Graphics.DrawImage( TheBoard.GetBitmap(), this.ClientRectangle );
        }

        private void MainForm_KeyDown( object sender, KeyEventArgs e )
        {
            if ( e.KeyCode == Keys.Space )
                TheBoard.MoveCurrentPiece( Board.PieceMove.Rotate );
            if ( e.KeyCode == Keys.Left )
                TheBoard.MoveCurrentPiece( Board.PieceMove.Left );
            if ( e.KeyCode == Keys.Right )
                TheBoard.MoveCurrentPiece( Board.PieceMove.Right );
            //if ( e.KeyCode == Keys.Up )
            //    TheBoard.MoveCurrentPiece( Board.PieceMove.Up );
            if ( e.KeyCode == Keys.Down )
                TheBoard.MoveCurrentPiece( Board.PieceMove.Down );
            Invalidate();
        }

    }
}
