﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace WebApplication24
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load( object sender, EventArgs e )
        {
        }

        protected void ListView1_DataBound( object sender, EventArgs e )
        {
            InitializeCountDescription();        
        }

        private void InitializeCountDescription()
        {
            int _count = DataModel.Instance.Persons.Count;

            int start = ListView1.GetActivePager().StartRowIndex;
            int end = Math.Min( _count, start + ListView1.GetActivePager().PageSize );

            Label lblItemCount = ControlHelper.Find( this, "lblListCount" ) as Label;
            if ( lblItemCount != null )
                lblItemCount.Text = string.Format( "{0}-{1} (from {2})", start + 1, end, _count );
        }

        protected void SetPageSize_SelectedChanged( object sender, EventArgs e )
        {
            DropDownList pageSize = (DropDownList)sender;

            int NewSize = Convert.ToInt32( pageSize.Text );

            ListView1.GetActivePager().SetPageProperties( 0, NewSize, true );
        }

    }
}
