﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace WebApplication24
{
    public class DataModel
    {
        public static DataModel Instance
        {
            get
            {
                if ( HttpContext.Current.Application["model"] == null )
                {
                    DataModel model = new DataModel();
                    model.Initialize();
                    HttpContext.Current.Application["model"] = model;
                }
                return (DataModel)HttpContext.Current.Application["model"];
            }
        }

        public List<Person> Persons;

        public void Initialize()
        {
            Persons = new List<Person>();

            Enumerable
                .Range( 1, 657 )
                .ToList()
                .ForEach( i => Persons.Add( new Person() { Name = "Name " + i.ToString(), Surname = "Surname " + i.ToString() } ) );
        }
    }
}
