﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO.Compression;
using System.IO;
using System.Web.Services.Protocols;

namespace ConsoleApplication60.MyService
{
    public partial class Service1 
    {
        #region WebResponseCompress

        protected override WebRequest GetWebRequest( Uri uri )
        {
           HttpWebRequest request = (HttpWebRequest)base.GetWebRequest( uri );
            request.Headers.Add( "Accept-Encoding", "gzip, deflate" );
        
            return new HttpWebRequestCompressed( request );
            //return request;
        }

        //protected override WebResponse GetWebResponse( WebRequest request )
        //{
        //    return new HttpWebResponseDecompressed( request );
        //}

        #endregion
    }

    public class HttpWebRequestCompressed : System.Net.WebRequest
    {
        private HttpWebRequest request;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="request"></param>
        public HttpWebRequestCompressed( WebRequest request )
        {
            this.request = (HttpWebRequest)request;
        }

        public override WebResponse GetResponse()
        {
            return new HttpWebResponseDecompressed( this.request );
        }

        public override Stream GetRequestStream()
        {
            return new GZipStream( request.GetRequestStream(), CompressionMode.Compress );
        }

        public override string Method
        {
            get
            {
                return request.Method;
            }
            set
            {
                request.Method = value;
            }
        }

        public override WebHeaderCollection Headers
        {
            get
            {
                return this.request.Headers;
            }
            set
            {
                this.request.Headers = value;                     
            }
        }

        public override string ContentType
        {
            get
            {
                return this.request.ContentType.ToString();
            }
            set
            {
                this.request.ContentType = value;
            }
        }
    }

    /// <summary>
    /// 
    /// </summary>
    public class HttpWebResponseDecompressed : System.Net.WebResponse
    {
        private HttpWebResponse response;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="request"></param>
        public HttpWebResponseDecompressed( WebRequest request )
        {
            try
            {
                response = (HttpWebResponse)request.GetResponse();
            }
            catch ( WebException ex )
            {
                response = (HttpWebResponse)ex.Response;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public override void Close()
        {
            response.Close();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override Stream GetResponseStream()
        {
            // Stream compressedStream = null;

            if ( response.ContentEncoding == "gzip" )
            {
                return new GZipStream( response.GetResponseStream(), CompressionMode.Decompress );
            }
            else if ( response.ContentEncoding == "deflate" )
            {
                return new DeflateStream( response.GetResponseStream(), CompressionMode.Decompress );
            }
            else
            {
                if ( response.StatusCode == HttpStatusCode.InternalServerError )
                    return new GZipStream( response.GetResponseStream(), CompressionMode.Decompress );

                return response.GetResponseStream();
            }
        }
        /// <summary>
        /// 
        /// </summary>
        public override long ContentLength
        {
            get { return response.ContentLength; }
        }
        /// <summary>
        /// 
        /// </summary>
        public override string ContentType
        {
            get { return response.ContentType; }
        }
        /// <summary>
        /// 
        /// </summary>
        public override System.Net.WebHeaderCollection Headers
        {
            get { return response.Headers; }
        }
        /// <summary>
        /// 
        /// </summary>
        public override System.Uri ResponseUri
        {
            get { return response.ResponseUri; }
        }
    } 

}
