﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Ajax.WebForms
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load( object sender, EventArgs e )
        {
            if ( this.IsCallback() )
                return;

            if ( !this.IsPostBack )
            {
                InitializeCountries( DropDownList1 );
                InitializeCountries( DropDownList3 );
            }

            // zdarzenie client-side dla AJAX
            DropDownList3.Attributes["onchange"] = "FillCityList()";
        }

        /// <summary>
        /// W przypadku Callbacku do tej samej strony,
        /// callback można odróżnić od zwykłego PostBack jakkolwiek,
        /// byleby sposób odróżniania był ustalony.
        /// 
        /// W tym przypadku: QueryString
        /// </summary>
        /// <returns></returns>
        protected bool IsCallback()
        {
            if ( Request.QueryString["AJAX"] != null )
            {
                string kraj = Request.QueryString["COUNTRY"];
                if ( kraj != null )
                {
                    Response.Clear();
                    Response.Write( GetCityListAJAX( kraj ) );
                    Response.Flush();
                    Response.End();

                    return true;
                }
            }

            return false;
        }

        void InitializeCountries( DropDownList dropDownList )
        {
            string[] countries = { "Polska", "Niemcy", "Francja", "USA" };
            foreach ( string country in countries )
                dropDownList.Items.Add( country );
        }

        /// <summary>
        /// Ten formant DropDownList1, napełnia listę elementów kontrolki podrzędnej, DropDownList2,
        /// w zwykły sposób, przetwarzając zdarzenie na serwerze
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void DropDownList1_SelectedIndexChanged( object sender, EventArgs e )
        {
            if ( DropDownList1.SelectedItem != null )
            {
                DropDownList2.Items.Clear();

                foreach ( string item in GetCityList( DropDownList1.SelectedItem.Text ) )
                {
                    DropDownList2.Items.Add( item );
                }
            }
        }

        private IEnumerable<string> GetCityList( string Country )
        {
            for ( int i = 0; i < 5; i++ )
                yield return Country + i.ToString();
        }

        private string GetCityListAJAX( string Country )
        {
            return string.Join( "|", GetCityList( Country ) );
        }

        /// <summary>
        /// Ponieważ formant DropDownList2 został napełniony w zwykły sposób,
        /// to w zwykły sposób można z niego odczytać wartość
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button1_Click( object sender, EventArgs e )
        {
            if ( DropDownList2.SelectedItem != null )
                Response.Write( DropDownList2.SelectedValue );
        }
        /// <summary>
        /// Ponieważ formant DropDownList4 został napełniony poza zwykłym potokiem przetwarzania,
        /// dostęp do wybranego elementu nie jest możliwy w standardowy sposób
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button2_Click( object sender, EventArgs e )
        {
            // uwaga! tak nie wolno!			
            //if ( DropDownList4.SelectedItem != null )
            //	Response.Write( DropDownList4.SelectedValue );

            string[] values = Request.Form.GetValues( DropDownList4.ClientID );
            if ( values.Length == 1 )
                Response.Write( values[0] );
        }

    }
}