﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Ajax.MVC.Models.Home;

namespace Ajax.MVC.Controllers
{
    public class AjaxController : Controller
    {
        private List<SelectListItem> CountryItems( string SelectedCountry )
        {
            List<SelectListItem> ret = new List<SelectListItem>();

            for ( int i = 0; i < 4; i++ )
            {
                string country = "country" + i.ToString();
                ret.Add( new SelectListItem() { Text = country, Selected = ( country == SelectedCountry ) } );
            }

            return ret;
        }

        private List<SelectListItem> CityItems( string SelectedCountry, string SelectedCity )
        {
            List<SelectListItem> ret = new List<SelectListItem>();

            if ( !string.IsNullOrEmpty( SelectedCountry ) )
                for ( int i = 0; i < 5; i++ )
                {
                    string city = string.Format( "{0} city {1}", SelectedCountry, i );
                    ret.Add( new SelectListItem() { Text = city, Selected = ( city == SelectedCity ) } );
                }

            return ret;
        }

        //
        // GET: /Ajax/

        public ActionResult Index()
        {
            IndexModel model = new IndexModel();
            model.CountryItems = CountryItems( string.Empty );
            model.CityItems = CityItems( string.Empty, string.Empty );

            return View( model );
        }

        [HttpPost]
        public ActionResult FormContent(string Country, string City )
        {
            IndexModel model = new IndexModel();
            model.CountryItems = CountryItems( Country );
            model.CityItems = CityItems( Country, City );

            ViewBag.SelectedCity = City;

            return PartialView( model );
        }

    }
}
