# -*- coding: utf-8 -*-

import math
import random
import copy
import itertools
import Tkinter

KOLONIA = 20
ROZMNOZ = 10
ILE_RAZY_POWIELIC = 3
ILE_PODMIENIC = 10
ILOSC_MUTACJI = 2
ITERACJI = 200

ROZMIAR = 400

class Antygen(object):
    def __init__(self, punkty, mapa, permutuj = False):
        self._kolejnosc = punkty[:]
        self._mapa = mapa
        self._droga = None
        
        if permutuj:
            random.shuffle(self._kolejnosc)
            
    def __lt__(self, antygen_prim):
        return self.droga() < antygen_prim.droga()
    
    def __repr__(self):
        return str(self.droga())
    
    def droga(self):
        if self._droga is not None:
            return self._droga
        else:
            self._droga = self._mapa.odleglosc(self._kolejnosc, cykl = True)
            return self._droga
    
    def _zamien(self, a, b):
        srodek = self._kolejnosc[a:(b + 1)]
        srodek.reverse()
        
        self._kolejnosc = self._kolejnosc[:a] + srodek + self._kolejnosc[(b + 1):]
    
    def hipermutuj(self):
        rozmiar = len(self._mapa.punkty())
        
        for x in range(ILOSC_MUTACJI):
            a = random.randint(0, rozmiar - 1)
            b = random.randint(0, rozmiar - 1)
            self._zamien(min(a, b), max(a, b))
        
        self._droga = None
            
    def _usun_przeciecie(self, (a, b), (c, d)):
        indeksy = dict([(x, self._kolejnosc.index(x)) for x in [a, b, c, d]])
        min_odleglosc = len(self._kolejnosc)
        
        for x, y in [(a, c), (a, d), (b, c), (b, d)]:
            odleglosc = abs(indeksy[x] - indeksy[y])
            if odleglosc <= min_odleglosc:
                min_odleglosc = odleglosc
                poczatek = min(indeksy[x], indeksy[y])
                koniec = max(indeksy[x], indeksy[y])
        
        self._zamien(poczatek, koniec)
        
    def usun_przeciecia(self):        
        krawedzie = set()
        poprzedni = self._kolejnosc[0]
        for obecny in self._kolejnosc[1:]:
            krawedzie.add((poprzedni, obecny))
            poprzedni = obecny
        else:
            krawedzie.add((self._kolejnosc[-1], self._kolejnosc[0]))
                
        while krawedzie:
            x = krawedzie.pop()
            
            for y in krawedzie:
                if self._mapa.przecinaja_sie(x, y):
                    self._usun_przeciecie(x, y)
        

    def kolejnosc(self):
        return self._kolejnosc
    
    def wynik_wzgledny(self, min, max):
        return 1 - ((self.droga() - min)/(max - min))
    
    def generator_kroku(self):
        for krok in itertools.cycle(self._kolejnosc):
            yield krok
    
class Mapa(object):
    def __init__(self, data, root):
        plik = file(data, 'r')
        linie = plik.read().split('\n')
        plik.close()
        
        self._punkt = dict(zip(range(1, len(linie) + 1), map(lambda a: map(int, a.split(', ')), linie)))
        self._odleglosc = {}
        self._rozmiar = len(self._punkt.keys())
        
        max_wymiar = max(map(max, self._punkt.values()))
        self._r = ROZMIAR / max_wymiar
        
        self._kanwa = Tkinter.Canvas(root, width = ROZMIAR, height = ROZMIAR)
                    
    def odleglosc(self, t, cykl = False):
        try:
            return self._odleglosc[t]
        except KeyError:
            try:
                return self._odleglosc[tuple(reversed(t))]
            except KeyError:
                a_x, a_y = self._punkt[t[0]]
                b_x, b_y = self._punkt[t[1]]
                
                dx = b_x - a_x
                dy = b_y - a_y
                
                odleglosc = math.sqrt(dx**2 + dy**2)
                self._odleglosc[t] = odleglosc
                
                return odleglosc
            
        except TypeError:
            sum = 0
            current = t[0]
            
            for next in t[1:]:
                sum += self.odleglosc((current, next))
                current = next
            
            if cykl:
                sum += self.odleglosc([t[0], t[-1]])
            
            return sum
        
    def punkty(self):
        return self._punkt.keys()
    
    def rysuj_rozwiazanie(self, rozwiazanie):
        self._kanwa.delete(Tkinter.ALL)
        
        for x, y in self._punkt.values():
            x *= self._r
            y *= self._r
            
            self._kanwa.create_rectangle(x, y, x + 3, y + 3)
        
        linia = []
        
        for punkt in rozwiazanie.kolejnosc():
            linia += map(lambda x: x * self._r + 1, self._punkt[punkt])
        
        linia += linia[:2]
        
        self._kanwa.create_line(*linia, width = 2)
        
        self._kanwa.pack(padx=10, pady=10)
    
    @classmethod
    def wyznacznik(cls, (ax, ay), (bx, by), (cx, cy)):
        return ax * by + bx * cy + cx * ay - cx * by - ax * cy - bx * ay
    
    def przecinaja_sie(self, (a, b), (c, d)):
        sign_c = Mapa.wyznacznik(*[self._punkt[x] for x in [a, b, c]]) < 0
        sign_d = Mapa.wyznacznik(*[self._punkt[x] for x in [a, b, d]]) < 0
        
        if sign_c == sign_d:
            return False
        
        if any([a == c, a == d, b == c, b == d]):
            return False
        
        xs = [self._punkt[a][0], self._punkt[b][0]]
        min_x = min(xs)
        max_x = max(xs)
        
        ys = [self._punkt[a][1], self._punkt[b][1]]
        min_y = min(ys)
        max_y = max(ys)
        
        c_x, c_y = self._punkt[c]
        
        if(min_x <= c_x <= max_x and min_y <= c_y <= max_y):
            return True
        
        d_x, d_y = self._punkt[d]
        
        if(min_x <= d_x <= max_x and min_y <= d_y <= max_y):
            return True
        
        return False
    
class Chodak(object):
    def __init__(self, data, root):
        self._mapa = Mapa(data, root)
        
    def rozmnazaj(self, do_rozrodu, granica, f_wynik):
        suma_wynikow = sum(map(lambda x: f_wynik(x) - granica, do_rozrodu))
        ile_rodzi = [(x, math.ceil(((f_wynik(x) - granica) * ROZMNOZ * ILE_RAZY_POWIELIC) / suma_wynikow)) for x in do_rozrodu]
        
        potomkowie = []
        
        for antygen, liczba_potomkow in ile_rodzi:
            for i in range(int(liczba_potomkow)):
                potomkowie.append(copy.copy(antygen))
        
        return potomkowie
    
    def krzyzuj_random(self, grupa):
        grupa = [x.generator_kroku() for x in grupa]
        nowy_cykl = []
        nieodwiedzone = set(self._mapa.punkty())
        
        while nieodwiedzone:
            krok = random.choice(grupa).next()
            
            if krok in nieodwiedzone:
                nowy_cykl.append(krok)
                nieodwiedzone.remove(krok)
        
        return Antygen(nowy_cykl, self._mapa)
    
    def test_usuwania_przeciec(self):
        anty = Antygen([2, 3, 1, 4, 5, 6, 7, 9, 8], self._mapa)
        anty.usun_przeciecia()
        self._mapa.rysuj_rozwiazanie(anty)
        
    def rozwiaz(self):
        punkty = self._mapa.punkty() 
        anty = [Antygen(punkty, self._mapa, permutuj = True) for x in range(KOLONIA)]
        najlepszy = anty[0].droga()
        
        i = 0
        
        while i < ITERACJI:
            print '.',
            
            cur_min = min(anty).droga()
            cur_max = max(anty).droga()
            
            if cur_min < najlepszy:
                najlepszy = cur_min
                najlepszy_antygen = min(anty)
                print najlepszy
                
            f_wynik = lambda x: x.wynik_wzgledny(cur_min, cur_max)
            
            if cur_max - cur_min < 0.001:
                print 'zakres!'
                break
            
            anty.sort(key = f_wynik, reverse = True)
            do_rozrodu = anty[:ROZMNOZ]
            granica = f_wynik(anty[ROZMNOZ])
            
            if granica > 0.99999:
                print 'granica!'
                break
            
            potomkowie = self.rozmnazaj(do_rozrodu, granica, f_wynik)
            [x.hipermutuj() for x in potomkowie]
            potomkowie.sort()

            random.shuffle(anty)
            
            anty = anty[:(KOLONIA - ILE_PODMIENIC)] + potomkowie[:ILE_PODMIENIC]
            
            i += 1
        
        self._mapa.rysuj_rozwiazanie(najlepszy_antygen)
        print '\nwynik: %s' % najlepszy_antygen._kolejnosc
        
if __name__ == '__main__':
    root = Tkinter.Tk()
    chodak = Chodak('data/simple_3.tsp', root)  
    root.after(0, lambda: chodak.rozwiaz())
    root.mainloop()
