package nettsp;

import java.awt.*;
import java.util.Random;
import javax.swing.JPanel;

public class TSPSolver extends Thread{
    protected int numCities;
    protected int numNeurons;
    protected City cities[];
    protected Neuron neurons[];
    protected JPanel displayPanel;
    protected boolean solve;
    protected double alpha, theta;

    public TSPSolver(){
	super();
	solve = false;
    }
    public synchronized void setNumCities(int n){
	numCities = n;
	numNeurons = (int)(n*3);
	initMap();
    }
    public synchronized void startSolving(){
	alpha = 0.4;
	theta = 0.2;
	solve = true;
    }

    public synchronized void initMap(){
	cities = new City[numCities];
	for(int i = 0; i < numCities; i++)
	    cities[i] = new City();

	neurons = new Neuron[numNeurons];
	for(int i = 0; i < numNeurons; i++)
	    neurons[i] = new Neuron(i, numNeurons, 0.25, 0.5 );

    }

    public void setPanel(JPanel jp){
	displayPanel = jp;
    }

    public void draw(Graphics g, int w, int h){
	Random rnd = new Random(77);
	if(cities != null)
	for(int i = 0; i < numCities; i++) {
	    g.setColor(new Color( rnd.nextInt(85)+10, rnd.nextInt(235), rnd.nextInt(35)));
	    g.fillOval(5+(int)(cities[i].x*(w-10)),5+(int)(cities[i].y*(h-10)),3,3);
	    g.drawOval((int)(cities[i].x*(w-10)),(int)(cities[i].y*(h-10)),12,12);
	}

	if(solve){
	    g.setColor(Color.ORANGE);
	    for(int i = 0; i <numNeurons-1; i++){
		g.drawLine((int)(neurons[i].x*w), (int)(neurons[i].y*h),
				(int)(neurons[i+1].x*w), (int)(neurons[i+1].y*h));
	    }

	    if(numNeurons>0)
	    g.drawLine((int)(neurons[numNeurons-1].x*w), (int)(neurons[numNeurons-1].y*h),
				(int)(neurons[0].x*w), (int)(neurons[0].y*h));
	}
    }

    @Override
    public void  run(){
	try{
	while(true){

	    if(solve)
		System.out.println("calculating...");
	    double momentum = 0.998;
	    for(int i = 0; solve; i++){
		theta *= momentum;
		alpha *= momentum;
		solveStep();
		if(displayPanel != null)
		    displayPanel.repaint();
		yield();
		sleep(5);
	    }
	    
	}
	}catch(Exception e){
	    System.out.println("Thread exception\n" + e);}
	}

    public synchronized void solveStep(){
	if(numCities <= 0)
	    return;
	Random rnd = new Random();
	int nc = rnd.nextInt(numCities);

	double minDist = neurons[0].dist(cities[nc]);
	int minDistNeuron = 0;

	for(int i = 0; i < numNeurons; i++)
	    if(minDist > neurons[i].dist(cities[nc])){
		minDist = neurons[i].dist(cities[nc]);
		minDistNeuron = i;
	    }
	adjustNeurons(minDistNeuron,nc);
    }

    private synchronized void adjustNeurons(int minDistNeuron, int nCt) {
	for(int i = 0; i < numNeurons; i++)
	    neurons[i].adjust(cities[nCt],neurons[i].elasticDist(neurons[minDistNeuron], theta)*alpha);
    }

}