package nettsp;

public class Neuron {
    public double x;
    public double y;

    public double crcX;
    public double crcY;

    public Neuron(Neuron n){
	x = n.x;
	y = n.y;
    }

    public Neuron(int k, int n, double radius, double center){

	crcX = radius*Math.cos((double)k*2.0*Math.PI/(double)n) + center;
	crcY = radius*Math.sin((double)k*2.0*Math.PI/(double)n) + center;
	x=Math.random();
	y=Math.random();
    }
    public double elasticDist(Neuron n,double theta){
	double xs = (this.crcX - n.crcX), ys = (this.crcY - n.crcY);
	double sdst = xs*xs+ys*ys;
	return Math.exp(-1.0*sdst/(2.0*theta*theta));

    }

    public double dist(City c){
	return Math.sqrt((x - c.x)*(x - c.x) +(y - c.y)*(y - c.y));
    }

    void adjust(City city,double factor) {
	x +=(factor*(city.x-x));
	y +=(factor*(city.y-y));
    }

    public Neuron kick(double coef){
	x += (Math.random()-0.5)*coef;
	y += (Math.random()-0.5)*coef;
	if(x<0.0)
	    x = 0.0;
	if(y<0.0)
	    y = 0.0;
	if(x>1.0)
	    x = 1.0;
	if(y>1.0)
	    y = 1.0;
	return this;
    }


}
