/*
 * Decompiled with CFR 0.152.
 */
package nettsp;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import javax.swing.JPanel;
import nettsp.City;
import nettsp.Neuron;

public class TSPSolver
extends Thread {
    protected int numCities;
    protected int numNeurons;
    protected City[] cities;
    protected Neuron[] neurons;
    protected JPanel displayPanel;
    protected boolean solve = false;
    protected double alpha;
    protected double theta;

    public synchronized void setNumCities(int n) {
        this.numCities = n;
        this.numNeurons = n * 3;
        this.initMap();
    }

    public synchronized void startSolving() {
        this.alpha = 0.4;
        this.theta = 0.2;
        this.solve = true;
    }

    public synchronized void initMap() {
        int i;
        this.cities = new City[this.numCities];
        for (i = 0; i < this.numCities; ++i) {
            this.cities[i] = new City();
        }
        this.neurons = new Neuron[this.numNeurons];
        for (i = 0; i < this.numNeurons; ++i) {
            this.neurons[i] = new Neuron(i, this.numNeurons, 0.25, 0.5);
        }
    }

    public void setPanel(JPanel jp) {
        this.displayPanel = jp;
    }

    public void draw(Graphics g, int w, int h) {
        int i;
        Random rnd = new Random(77L);
        if (this.cities != null) {
            for (i = 0; i < this.numCities; ++i) {
                g.setColor(new Color(rnd.nextInt(85) + 10, rnd.nextInt(235), rnd.nextInt(35)));
                g.fillOval(5 + (int)(this.cities[i].x * (double)(w - 10)), 5 + (int)(this.cities[i].y * (double)(h - 10)), 3, 3);
                g.drawOval((int)(this.cities[i].x * (double)(w - 10)), (int)(this.cities[i].y * (double)(h - 10)), 12, 12);
            }
        }
        if (this.solve) {
            g.setColor(Color.ORANGE);
            for (i = 0; i < this.numNeurons - 1; ++i) {
                g.drawLine((int)(this.neurons[i].x * (double)w), (int)(this.neurons[i].y * (double)h), (int)(this.neurons[i + 1].x * (double)w), (int)(this.neurons[i + 1].y * (double)h));
            }
            if (this.numNeurons > 0) {
                g.drawLine((int)(this.neurons[this.numNeurons - 1].x * (double)w), (int)(this.neurons[this.numNeurons - 1].y * (double)h), (int)(this.neurons[0].x * (double)w), (int)(this.neurons[0].y * (double)h));
            }
        }
    }

    public void run() {
        try {
            block2: while (true) {
                if (this.solve) {
                    System.out.println("calculating...");
                }
                double momentum = 0.998;
                int i = 0;
                while (true) {
                    if (!this.solve) continue block2;
                    this.theta *= momentum;
                    this.alpha *= momentum;
                    this.solveStep();
                    if (this.displayPanel != null) {
                        this.displayPanel.repaint();
                    }
                    TSPSolver.yield();
                    TSPSolver.sleep(5L);
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Thread exception\n" + e);
            return;
        }
    }

    public synchronized void solveStep() {
        if (this.numCities <= 0) {
            return;
        }
        Random rnd = new Random();
        int nc = rnd.nextInt(this.numCities);
        double minDist = this.neurons[0].dist(this.cities[nc]);
        int minDistNeuron = 0;
        for (int i = 0; i < this.numNeurons; ++i) {
            if (!(minDist > this.neurons[i].dist(this.cities[nc]))) continue;
            minDist = this.neurons[i].dist(this.cities[nc]);
            minDistNeuron = i;
        }
        this.adjustNeurons(minDistNeuron, nc);
    }

    private synchronized void adjustNeurons(int minDistNeuron, int nCt) {
        for (int i = 0; i < this.numNeurons; ++i) {
            this.neurons[i].adjust(this.cities[nCt], this.neurons[i].elasticDist(this.neurons[minDistNeuron], this.theta) * this.alpha);
        }
    }
}

