/*
 * Decompiled with CFR 0.152.
 */
package nettsp;

import nettsp.City;

public class Neuron {
    public double x;
    public double y;
    public double crcX;
    public double crcY;

    public Neuron(Neuron n) {
        this.x = n.x;
        this.y = n.y;
    }

    public Neuron(int k, int n, double radius, double center) {
        this.crcX = radius * Math.cos((double)k * 2.0 * Math.PI / (double)n) + center;
        this.crcY = radius * Math.sin((double)k * 2.0 * Math.PI / (double)n) + center;
        this.x = Math.random();
        this.y = Math.random();
    }

    public double elasticDist(Neuron n, double theta) {
        double xs = this.crcX - n.crcX;
        double ys = this.crcY - n.crcY;
        double sdst = xs * xs + ys * ys;
        return Math.exp(-1.0 * sdst / (2.0 * theta * theta));
    }

    public double dist(City c) {
        return Math.sqrt((this.x - c.x) * (this.x - c.x) + (this.y - c.y) * (this.y - c.y));
    }

    void adjust(City city, double factor) {
        this.x += factor * (city.x - this.x);
        this.y += factor * (city.y - this.y);
    }

    public Neuron kick(double coef) {
        this.x += (Math.random() - 0.5) * coef;
        this.y += (Math.random() - 0.5) * coef;
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.x > 1.0) {
            this.x = 1.0;
        }
        if (this.y > 1.0) {
            this.y = 1.0;
        }
        return this;
    }
}

