import numpy as np
from matplotlib.colors import LogNorm
from pylab import *
import Image
from visual import *
from visual.graph import *
from threading import Thread
import random
##############################################################################################################
def fun(x, y):
    #return np.abs(np.log(np.abs(x))+np.log(np.abs(y)))
    #Ackley function
    return -20.0 * np.exp( -0.2 * np.sqrt( 0.5 * (x*x + y*y) )) - np.exp( 0.5 * ( np.cos(2*np.pi*x) + np.cos(2*3.14*y) ) ) + 20 + np.e
    #Beales function 
    #return (1.5 -x + (x*y))**2 + (2.25 - x + (x*y**2))**2 + (2.625 - x + (x*y**3))**2
    #Easom function
    #return (-1 * np.cos(-x)* np.cos(-y)*np.exp(-(-x-np.pi)**2 - (-y-np.pi)**2)) +1
    

class Data(object):
    
    def fun(self, x,y = None):
        global fun
        if y == None:
            return fun(x[0],x[1])
        else:
            return fun(x,y)
    
    def optimum(self):
        #return [0,0]
        return [0,0]
        #return [3., 0.5]
        #return [-np.pi, -np.pi]
##############################################################################################################
class MapGenerator(object):
    
    def __init__(self, fun):
        self.x_start = -4.5
        self.x_end   = 4.5
        self.y_start = -4.5
        self.y_end   = 4.5
        self.dense   = 512
        self.fun     = fun

    
    def create_grid(self):
        x    = np.linspace(self.x_start, self.x_end, self.dense)
        y    = np.linspace(self.y_start, self.y_end, self.dense)
        X, Y = np.meshgrid(x, y)
        Z    = self.fun(X, Y)
        return Z
    
    
    def imsave(self, filename, X, **kwargs):
        figsize   = (np.array(X.shape)/100.0)[::-1]
        rcParams.update({'figure.figsize':figsize})
        fig       = figure(figsize=figsize)
        axes([0,0,1,1]) # Make the plot occupy the whole canvas
        axis('off')
        fig.set_size_inches(figsize)
        imshow(X,origin='lower', **kwargs)
        savefig(filename, facecolor='black', edgecolor='black', dpi=100)
        close(fig)

    
    def save(self):
        Z = self.create_grid()
        self.imsave("mapa.png", Z, norm=LogNorm(vmin=Z.min(), vmax=Z.max()))

##############################################################################################################
class Swarm(Thread):
    def __init__(self, fun):
        Thread.__init__(self)
        self.min          = -4.5
        self.max          = 4.5
        self.dimmensions  = 2
        self.isMinimizing = True
        self.best         = []
        self.particles    = []
        self.kolor        = color.green
        self.f            = fun
        self.best         = (None, None)
        self.maxiter      = 4000
        self.inercja      = 1.1
        #self.inercja      = 2
        self.c_2          = 1.95
        #self.c_2          = 0.01
        self.c_3          = 1.95
        #self.c_3          = 0.01

    
    def fun(self):
        return self.f( self.best )
    
    
    def addParticles(self, howMany):
        for i in range(howMany):
            particle = Particle(self, self.kolor)
            if i == 0:
                self.best = copy(particle.position)
            if self.isMinimizing:
                if particle.fun() < self.fun():
                    self.best = copy(particle.position)
            else:
                if particle.fun() > self.fun():
                    self.best = copy(particle.position)
            self.particles.append(particle)
    
    
    def run(self):
        for i in xrange(self.maxiter):
            print i
            rate(10)
            print self.best, self.fun()
            for particle in self.particles:
                particle.next()
            
    
##############################################################################################################

class Particle(sphere):
    def __init__(self, swarm, kolor):
        sphere.__init__(self)
        self.color     = kolor
        self.swarm     = swarm
        self.material  = materials.plastic
        self.position  = []
        for i in range(self.swarm.dimmensions):
            self.position.append(random.uniform(swarm.min, swarm.max))
        self.pos       = vector(self.position)
        self.position  = np.array(self.position)
        self.radius    = 0.04
        self.vel       = []
        for i in range(self.swarm.dimmensions):
            self.vel.append(random.uniform(-(self.swarm.max - self.swarm.min) , (self.swarm.max - self.swarm.min)))
        self.velocity  = vector(copy(self.vel))
        self.vel       = np.array(self.vel)
        self.best      = np.array(self.position)
        self.bestPoint = sphere(pos = vector(self.best), radius = 0.02, color = color.magenta, make_trail=True, trail_type="line",
              interval=1, retain=50)
        self.arrow     = arrow(pos=self.pos, axis=0.1*self.velocity, color=self.color)
    
    
    def fun(self):
        return self.swarm.f(self.position)
    
    
    def bestEval(self):
        return self.swarm.f(self.best)
    
    
    def check_best(self):
        if self.swarm.isMinimizing:
            if self.fun() < self.bestEval():
                self.best = copy(self.position)
            if self.fun() < self.swarm.fun():
                self.swarm.best = copy(self.position)
        else:
            if self.fun() > self.bestEval():
                self.best = copy(self.position)
            if self.fun() > self.swarm.fun():
                self.swarm.best = copy(self.position)
    
    def next(self):
        r_1           = random.uniform(0,1)
        r_2           = random.uniform(0,1)
        r_3           = random.uniform(0,1)
        c_1           = self.swarm.inercja
        c_2           = self.swarm.c_2
        c_3           = self.swarm.c_3
        self.vel      = c_1 * r_1 * self.vel + c_2 * r_2 * (self.best - self.position) + c_3 * r_3 * (self.swarm.best - self.position)
        self.position = self.position + self.vel
        self.check_best()
        self.update()

    
    def update(self):
        self.pos           = vector(self.position)        
        self.velocity      = vector(self.vel)
        self.bestPoint.pos = vector(self.best)
        self.arrow.pos     = self.pos
        self.arrow.axis    = 0.1 * self.velocity
            
##############################################################################################################

def main(data):
    mp               = MapGenerator(data.fun)
    mp.save()
    im               = Image.open("mapa.png")
    tex              = materials.texture(data=im, mapping="sign")
    scena            = display()
    scena.background = (114/255.0,0,0)
    scena.fullscreen = 0
    scena.autoscale  = 0
    scena.center     = data.optimum()
    box(axis=(0,0,1),length = 0.001, width = 9, height = 9, color=(114/255.0,0,0), material=tex)
    zer          = sphere()
    zer.position = (0,0,0)
    zer.material = materials.emissive
    zer.color    = color.white
    zer.radius   = 0.005
    zer.axis     = (0,0,1)
    zer.pos      = vector(zer.position)
    zerlabel     = label(pos=zer.pos,
        text='(0,0,0)', xoffset=-20,
        yoffset=-12, space=zer.radius,
        height=5, border=2,
        font='sans')
    minimum          = sphere()
    minimum.position = data.optimum()
    minimum.material = materials.emissive
    minimum.color    = color.blue
    minimum.radius   = 0.01
    minimum.axis     = (0,0,1)
    minimum.pos      = vector(minimum.position)
    minimumlabel     = label(pos=minimum.pos,
        text='Minimum', xoffset=-20,
        yoffset=-12, space=minimum.radius,
        height=10, border=2,
        font='sans')        
    

##############################################################################################################
#if __name__ == '__main__':
data = Data()
print 'a'
main(data)
swarm = Swarm(data.fun)
print 'a'
swarm.addParticles(20)
#raw_input('')
swarm.start()
        
