import java.util.Collections;
import java.util.Vector;

//instancja problemu plecakowego 0-1
public class KnapsackInstance {

	//liczba iteracji wykonanych przez algorytm
	private int iter;
	
	//liczba przedmiotow w plecaku
	private int n;
	
	//pojemnosc plecaka
	private int capacity;
	
	//przedmioty w plecaku
	private Vector<KnapsackItem> items;
	
	//aktualnie przegladane rozwiazanie
	private Vector<Boolean> currentSolution;
	
	//aktualnie najlepsze rozwiazanie
	private Vector<Boolean> bestSolution;
	
	//wartosc plecaka w najlepszym aktualnym rozwiazaniu
	private int bestSolutionProfit;
	
	//konstruktor
	public KnapsackInstance(int n, int capacity, Vector<KnapsackItem> items) {
		super();
		this.n = n;
		this.capacity = capacity;
		this.items = items;
		
		currentSolution = new Vector<Boolean>(n);
		bestSolution = new Vector<Boolean>(n);
		currentSolution.setSize(n);
		bestSolution.setSize(n);
		
		iter = 0;
		bestSolutionProfit = 0;
	}		
	
	//metoda rozwiazujaca problem
	public void solve() {
		Collections.sort(items);
		
		solve(0,0,0);
	}

	@SuppressWarnings("unchecked")
	private void solve(int i, int profit, int weight){
		iter++;
		if(weight <= capacity && profit>bestSolutionProfit)
		{
			bestSolutionProfit = profit;
			bestSolution = (Vector<Boolean>) currentSolution.clone();			
			bestSolution.setSize(i);
			
			//System.out.println("Znalazlem lepsze rozwiazanie o zysku: " + profit);
		}

		//System.out.println(i + " " + profit + " " + weight);
		
		if(promising(i, weight, profit)) {

			currentSolution.set(i, true);
			solve(i+1, profit + items.elementAt(i).getValue(), weight + items.elementAt(i).getWeight());
			currentSolution.set(i, false);
			solve(i+1, profit, weight);
		}
		
	}
	
	private boolean promising(int i, int weight, int profit) {
		int j;
		int totalWeight;
		double bound;
		
		if(weight >= capacity)
			return false;
		
		j = i;
		bound = profit;
		totalWeight = weight;
		
		while(j < n && totalWeight+items.elementAt(j).getWeight() <= capacity) {
			totalWeight += items.elementAt(j).getWeight();
			bound += items.elementAt(j).getValue();
			j++;
		}
		
		if(j<n)
			bound += (capacity - totalWeight) * 
				items.elementAt(j).getValue()/items.elementAt(j).getWeight();
		
		return (bound > bestSolutionProfit);
	}
	
	//drukowanie na ekran najlepszego rozwiazania
	public void printBestSolution() {
		System.out.println(getBestSolution());
	}

	//generowanie wiadomosci z najlepszym rozwiazaniem
	public String getBestSolution() {
		
		String wynik = "Najlepsze rozwiazanie ma wartosc " + bestSolutionProfit + "\n";
		wynik += "Aby go znalezc algorytm przeszukal " + iter + " wezlow\n";
		wynik += "Wziete przedmioty to: \n";
				
		for(int i = 0;i<bestSolution.size();i++)
		{
			if(bestSolution.elementAt(i)!= null && bestSolution.elementAt(i)) {
				wynik += items.elementAt(i).getWeight() + " " + items.elementAt(i).getValue() + "\n";
			}
		}
		return wynik;
	}

	public int getBestSolutionProfit() {
		return bestSolutionProfit;
	}

	public int getIter() {
		return iter;
	}

	
}
