import java.util.Random;
import java.util.Vector;


public class Knapsack {

	//generowanie losowej instancji problemu
	static KnapsackInstance randomInstance(int n){
		int sumOfAllWeights = 0;
		Vector<KnapsackItem> vec = new Vector<KnapsackItem>();
		
		Random rand = new Random();
		
		for(int i=0;i<n;i++){
			int weight = rand.nextInt(10*n);
			int value = rand.nextInt(10*n);
			
			sumOfAllWeights += weight;
			vec.add(new KnapsackItem(value,weight));
		}
		return(new KnapsackInstance(n, sumOfAllWeights/2, vec));
	}
	
	public static void main(String[] args) {
		
		KnapsackInstance knap;
		
		/*
		
		//przyklad z ksiazki		
		KnapsackItem a = new KnapsackItem(30, 5);
		KnapsackItem b = new KnapsackItem(40, 2);
		KnapsackItem c = new KnapsackItem(50, 10);
		KnapsackItem d = new KnapsackItem(10, 5);

		Vector<KnapsackItem> vec = new Vector<KnapsackItem>();
		vec.add(a);
		vec.add(b);
		vec.add(c);
		vec.add(d);		
		
		knap = new KnapsackInstance(4, 16, vec);
		
		knap.solve();
		knap.printBestSolution();
		
		*/
		
		//generowanie statystyk
		
		int wartosci[] = {5,10,20,50,100,200,500,1000,2000};
		int probka = 50;
		
		for(int i : wartosci){
			int suma = 0;
			int max = 0;
			for(int j=0;j<probka;j++){
				knap = randomInstance(i);
				knap.solve();
				if (knap.getIter() > max) max = knap.getIter();
				suma += knap.getIter();
			}
			suma /= probka;
			//System.out.println(i + "\t" + suma + "\t" + max);
			System.out.println("Dla " + i + " elementow srednia przeszukanych wezlow dla probki: " + probka + " to: " + suma + " Najwiecej przeszukanych wezlow to: " + max);
		}

	}

}
