import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


public class AddressBookDOMParser {
	Document document = null;
	
	AddressBookDOMParser(String filename) throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory factory
			= DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		File f = new File(filename);
	
		factory.setValidating(true);		// walidacja on/off
		factory.setIgnoringElementContentWhitespace(true);
		builder = factory.newDocumentBuilder();
		document = builder.parse(f);
	}
	
	public void printDocumentStructure() {
		this.printNode(document.getDocumentElement(), "");
	}
	
	public void printNode(Node n, String dist) {
		if (n.getNodeType() == Node.TEXT_NODE) {
			System.out.println(dist + "\"" + n.getNodeValue().trim() + "\"");
			return;
		}
		
		System.out.print(dist + "<" + n.getNodeName());
		this.printAttributes(n);
		System.out.println(">");
		this.printChildren(n, dist + "\t");
		System.out.println(dist + "</" + n.getNodeName() + ">");
	}
	
	private void printAttributes(Node n) {
		NamedNodeMap attributes = n.getAttributes();
		
		for (int i=0; i<attributes.getLength(); i++) {
			Node attr = attributes.item(i);
			
			System.out.print(" " 
					+ attr.getNodeName()
					+ "=\""
					+ attr.getNodeValue()
					+ "\"");
		}
	}
	
	private void printChildren(Node n, String dist) {
		NodeList nList = n.getChildNodes();
		
		for (int i=0; i<nList.getLength(); i++) {
			Node child = nList.item(i);
			
			this.printNode(child, dist);
		}
	}
	
	public static void main(String [] args) {
		AddressBookDOMParser abdp = null;
		
		try {
			abdp = new AddressBookDOMParser("address-book-with-dtd.xml");
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			return;
		} catch (SAXException e) {
			e.printStackTrace();
			return;
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		
		abdp.printDocumentStructure();
	}
}
