<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output indent="yes" method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>

<xsl:template match="/">
<html>
  <body>
  	(b - 3)
	<table border="1"><tr><th>First name</th><th>Surname</th><th>Address</th><th>Phone</th>
  	<th>E-mail</th><th>Status</th><th>Count</th></tr>
  	<xsl:for-each select="/address_book/person">
  		<xsl:sort select="@status"/>
  		<tr>
	  		<td><xsl:value-of select="firstname"/></td>
	  		<td><xsl:value-of select="surname"/></td>
	  		<td><xsl:value-of select="address"/></td>
	  		<td><xsl:value-of select="phone"/></td>
	  		<td><xsl:value-of select="email"/></td>
	  		<td><xsl:value-of select="@status"/></td>
	  		<xsl:variable name="nazwa" select="@status"/>
	  		<td><xsl:value-of select="count(/address_book/person[@status = $nazwa])"/></td>	  		  		
  		</tr>
  	</xsl:for-each>
  	</table>
  	Count with phone: <xsl:value-of select="count(/address_book/person/phone[text()])"/>
  </body>
</html>
</xsl:template>

</xsl:stylesheet>

