import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DocumentCreator {
	Document doc;
	
	DocumentCreator(String filename) throws ParserConfigurationException, TransformerException, SAXException, IOException {
		DocumentBuilderFactory factory
			= DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		
		 // Use a Transformer for output
		TransformerFactory tFactory =
		    TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		DOMSource source = null;
		StreamResult result = new StreamResult(System.out);
		File f = new File(filename);

		builder = factory.newDocumentBuilder();
		doc = builder.newDocument();
		
		Element e = doc.createElement("pierwszy");
		doc.appendChild(e);
		e.setAttribute("attr1", "val1");
		e.appendChild(doc.createElement("d"));
		
		source = new DOMSource(doc);
		transformer.transform(source, result); 
	}
	
	public static void main(String [] args) {
		try {
			new DocumentCreator("address-book-with-dtd.xml");
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (TransformerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
