import java.lang.reflect.*;

public class class_hierarchy
{
    static void print_hierarchy(Class c, String indent)
    {
	System.out.println(indent + c); 
	Class superclass = c.getSuperclass();
	Class[] ifaces   = c.getInterfaces();

	for (int i = 0; i < ifaces.length; i++)
	    print_hierarchy(ifaces[i], indent + "| ");
	if(superclass != null)
	    print_hierarchy(superclass, indent + "> ");
    }

    public static void main(String argv[])
    {
	String class_name = argv[0];
	Class c;

	try {
	    c = Class.forName(class_name);
	} catch(Throwable e) {
	    System.out.println(class_name + " not found");
	    return;
	}
	print_hierarchy(c, "");
    }
}
