import java.beans.*;

public class Account implements java.io.Serializable {
    VetoableChangeSupport ctrls = new VetoableChangeSupport(this);
    public synchronized void addVetoableChangeListener(VetoableChangeListener l)
    {
        ctrls.addVetoableChangeListener(l);
    }
    public synchronized void removeVetoableChangeListener(VetoableChangeListener l)
    {
        ctrls.removeVetoableChangeListener(l);
    }

    float balance = 100.0f;
    public float getBalance() { return balance; }
    public void setBalance(float newBalance)
    {
        try {
            ctrls.fireVetoableChange("balance", new Float(balance), new Float(newBalance));
            balance = newBalance;
        } catch (PropertyVetoException e) {
            System.out.println("The change has been vetoed: "  + e.getMessage());
        }
    }
}
