Require Import Utf8.
Require Import List.

Definition monotone (P : nat → Prop) := ∀ n, P (S n) → P n.

Definition IProp := { P : nat → Prop | monotone P }.

Fixpoint IRel (l : list Type) : Type :=
  match l with
  | nil    => IProp
  | A :: l => A → IRel l
  end.

Module Private.

Record IValidStruct :=
  { IValidStruct_valid_at : nat → IProp → Prop
  ; IValidStruct_intro    : ∀ (P : IProp) n, proj1_sig P n → IValidStruct_valid_at n P
  ; IValidStruct_elim     : ∀ (P : IProp) n, IValidStruct_valid_at n P → proj1_sig P n
  }.

Definition I_valid_struct : IValidStruct.
  split with (IValidStruct_valid_at := λ n P, proj1_sig P n); auto.
Qed.

End Private.

Definition I_valid_at (n : nat) (P : IProp) : Prop :=
  Private.I_valid_struct.(Private.IValidStruct_valid_at) n P.
Definition I_valid (P : IProp) := ∀ n, I_valid_at n P.

Notation "n ⊨ P" := (I_valid_at n P) (at level 98, no associativity).
Notation "⊨ P" := (I_valid P) (at level 98, no associativity).

Lemma I_valid_intro : ∀ (P : IProp) n, proj1_sig P n → (n ⊨ P).
Proof.
apply Private.IValidStruct_intro.
Qed.

Lemma I_valid_elim : ∀ (P : IProp) n, (n ⊨ P) → proj1_sig P n.
Proof.
apply Private.IValidStruct_elim.
Qed.

Lemma I_valid_monotone_S (P : IProp) (n : nat) :
  (S n ⊨ P) → (n ⊨ P).
Proof.
intro H; apply I_valid_elim in H; apply I_valid_intro; destruct P; simpl; auto.
Qed.

Lemma I_valid_monotone (P : IProp) (n m : nat) :
  n ≤ m → (m ⊨ P) → (n ⊨ P).
Proof.
induction 1; trivial.
intro; apply IHle; apply I_valid_monotone_S; assumption.
Qed.

(* ========================================================================= *)
(* Embeding Prop *)

Definition I_Prop (P : Prop) : IProp.
exists (λ _, P); unfold monotone; auto.
Defined.

Notation "( P )ᵢ" := (I_Prop P).

Lemma I_Prop_intro (P : Prop) n : P → (n ⊨ (P)ᵢ).
Proof.
intro H; apply I_valid_intro; assumption.
Qed.

Lemma I_Prop_elim (P : Prop) n : (n ⊨ (P)ᵢ) → P.
Proof.
intro H; apply I_valid_elim in H; apply H.
Qed.