Require Import Utf8.
Require Import IxFree.Base.

Definition I_disj_func (P Q : IProp) : nat → Prop :=
  λ n, (n ⊨ P) ∨ (n ⊨ Q).
Lemma I_disj_func_monotone (P Q : IProp) :
  monotone (I_disj_func P Q).
Proof.
unfold monotone; unfold I_disj_func.
intros n H; destruct H; apply I_valid_monotone_S in H; auto.
Qed.

Definition I_disj (P Q : IProp) : IProp.
exists (I_disj_func P Q); apply I_disj_func_monotone.
Defined.

Notation "A '∨ᵢ' B" := (I_disj A B) (at level 85, right associativity).
