Require Import Utf8.
Require Import Lang TermRelation Simulation.
Require Import LangProperties.

Inductive var (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_var : ∀ x : V, var R V (val_var x) (val_var x)
.

Inductive var2 (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_var2 : ∀ x y : V,
    var2 R V (tm_app (val_var x) (val_var y))
             (tm_app (val_var x) (val_var y))
.

Inductive lam (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_lam : ∀ (t₁ t₂ : term (inc V)),
    R _ t₁ t₂ →
    lam R _ (val_lam t₁) (val_lam t₂)
.

Inductive sft (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_sft : sft R V val_sft val_sft
.

Inductive sft2 (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_sft2 : ∀ x : V,
    sft2 R V (tm_app val_sft (val_var x)) (tm_app val_sft (val_var x))
.

Inductive app (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_app : ∀ (t₁ t₂ s₁ s₂ : term V),
    R V t₁ t₂ → R V s₁ s₂ → app R V (tm_app t₁ s₁) (tm_app t₂ s₂)
.

Inductive subst (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_subst : ∀ (t₁ t₂ : term (inc V)) (v₁ v₂ : value V),
    R _ t₁ t₂ →
    val_rel R _ v₁ v₂ →
    subst R V (t₁ {t↦ v₁}) (t₂ {t↦ v₂})
.

Inductive map (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_map : ∀ (W : Set) (t₁ t₂ : term W) (f : W → V),
    R _ t₁ t₂ →
    map R V (tmap f t₁) (tmap f t₂)
.

Inductive ectxr (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_ectxr : ∀ (E₁ E₂ : ectx V) (t₁ t₂ : term V),
    ectx_rel R _ E₁ E₂ →
    R _ t₁ t₂ →
    ectxr R V (E₁ $[ t₁ ]) (E₂ $[ t₂ ])
.

Inductive ectxrst (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_ectxrst : ∀ (E₁ E₂ : ectx V) (t₁ t₂ : term V),
    ectx_rst_rel R _ E₁ E₂ →
    R _ t₁ t₂ →
    ectxrst R V (tm_rst (E₁ $[ t₁ ])) (tm_rst (E₂ $[ t₂ ]))
.

Inductive mctxvpure (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_mctxvpure : ∀ (F₁ F₂ : mctx V) (t₁ t₂ : term V),
    pure_term t₁ → pure_term t₂ →
    mctx_val_rel R _ F₁ F₂ →
    R _ t₁ t₂ →
    mctxvpure R V (F₁ $$[ t₁ ]) (F₂ $$[ t₂ ])
.

Inductive redr (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
| Mk_redr : ∀ t₁' t₂' : term V,
    red_rtc t₁ t₁' →
    red_rtc t₂ t₂' →
    R V t₁' t₂' →
    redr R V t₁ t₂
.

Lemma Mk_map_id (R : term_rel) {V : Set} {t₁ t₂ : term V} :
  R _ t₁ t₂ → map R _ t₁ t₂.
Proof.
intro HR; apply Mk_map with (f := λ x, x) in HR.
repeat rewrite tmonad_map_id' in HR; assumption.
Qed.

Lemma Mk_redr_id (R : term_rel) {V : Set} {t₁ t₂ : term V} :
  R _ t₁ t₂ → redr R _ t₁ t₂.
Proof.
intro HR; econstructor; [ | | eassumption ]; constructor 1.
Qed.

Lemma Mk_appV {V : Set} (R : term_rel) (v₁ v₂ : value V) (t₁ t₂ : term V) :
    val_rel R _ v₁ v₂ →
    R _ t₁ t₂ →
    ectxr R V (tm_app v₁ t₁) (tm_app v₂ t₂).
Proof.
intros Hv Ht.
change (ectxr R V (ectx_app2 v₁ ectx_mt $[ t₁ ])
                  (ectx_app2 v₂ ectx_mt $[ t₂ ])).
constructor; assumption.
Qed.

Definition rst : term_rel → term_rel := ectxrst ◦ ((redr ◦ var) ∪ id).
Lemma Mk_rst {V : Set} (R : term_rel) (t₁ t₂ : term V) :
    R _ t₁ t₂ →
    rst R _ (tm_rst t₁) (tm_rst t₂).
Proof.
intro Ht; apply Mk_ectxrst with (E₁ := ectx_mt) (E₂ := ectx_mt).
+ left; econstructor; simpl.
  - econstructor 2; [ apply red_reset | constructor 1 ].
  - econstructor 2; [ apply red_reset | constructor 1 ].
  - constructor.
+ right; assumption.
Qed.

Definition mctxr : term_rel → term_rel := ectxr ∪ (mctxvpure ◦ (id ∪ ectxrst)).
Lemma Mk_mctxr {V : Set} (R : term_rel) (F₁ F₂ : mctx V) (t₁ t₂ : term V) :
    mctx_rel R _ F₁ F₂ →
    R _ t₁ t₂ →
    mctxr R _ (F₁ $$[ t₁ ]) (F₂ $$[ t₂ ]).
Proof.
intros HF Ht; destruct HF as [ E₁ E₂ HE | F₁ F₂ E₁ E₂ HE HF ].
+ rewrite mplug_pure, mplug_pure; left; constructor; assumption.
+ rewrite mcomp_mplug, mcomp_mplug; simpl.
  right; constructor.
  - constructor.
  - constructor.
  - left; assumption.
  - rewrite mplug_pure, mplug_pure; right; constructor; assumption.
Qed.