Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import LangProperties Reduction Monotonicity.
Require Import UpToMap CtxComp.

Definition sas_body_val : term_rel → term_rel :=
  subst ◦ map ◦ (id ∪ (subst ◦ map)).

Definition sas_body_lam : term_rel → term_rel :=
  redr ◦ ectxrst ◦ map ◦ subst ◦ map ◦ (id ∪ (subst ◦ map)).

Inductive subst_act' (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
| SA_subst : subst R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_subst_map : (subst ◦ map) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_subst_map2 : (subst ◦ map ◦ (id ∪ (subst ◦ map))) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_beta  : (mctxr ◦ subst ◦ (map ∪ (subst ◦ map))) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_shift : (mctxvpure ◦ subst ◦ map ◦
      (id ∪ (sas_body_val ∪ sas_body_lam))) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_comp  :
    (ectxr ◦ map ◦ subst ◦ map ◦ (id ∪ (subst ◦ map))) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
| SA_comp_rst  :
    (ectxrst ◦ map ◦ subst ◦ map ◦ (id ∪ (subst ◦ map))) R _ t₁ t₂ →
    subst_act' R V t₁ t₂
.

Definition subst_act : term_rel → term_rel :=
  ((id ∪ mctxvpure) ◦ (id ∪ subst) ◦ map ◦
  (id ∪ (((redr ◦ (ectxr ∪ ectxrst) ◦ map) ∪ id) ◦
    subst ◦ map ◦ (id ∪ (subst ◦ map))))).

Lemma subst_act_repr (R : term_rel) :
  subst_act' R ⊆ subst_act R.
Proof.
intros V t₁ t₂ H; destruct H; unfold subst_act.
+ left; right; eapply subst_monotone; [ | eassumption ].
  apply map_id_monotone, sum_sub_l; auto.
+ left; right; eapply subst_monotone; [ | eassumption ].
  apply map_monotone, sum_sub_l; auto.
+ left; right; eapply subst_monotone; [ | eassumption ].
  apply map_monotone, sum_subset.
  - apply sum_sub_l; auto.
  - apply sum_sub_r, sum_sub_r, subst_monotone, map_monotone, sum_sub_l; auto.
+ unfold mctxr in H; destruct H as [ H | H ].
  - left; left; apply Mk_map_id; right; left.
    apply Mk_redr_id; left; eapply ectxr_monotone; [ | eassumption ].
    apply map_id_monotone, subst_monotone, sum_subset.
    * apply map_monotone, sum_sub_l; auto.
    * apply map_id_monotone, sum_sub_r; auto.
  - right; eapply mctxvpure_monotone; [ | eassumption ].
    apply sum_sub_l, map_id_monotone, sum_sub_r, sum_subset.
    * { apply sum_sub_r, subst_monotone, sum_subset.
      + apply map_monotone, sum_sub_l; auto.
      + apply map_id_monotone, sum_sub_r, subst_monotone; auto.
      }
    * apply sum_sub_l, redr_id_monotone, sum_sub_r, ectxrst_monotone,
        map_id_monotone, subst_monotone.
      { apply sum_subset.
      + apply map_monotone, sum_sub_l; auto.
      + apply map_id_monotone, sum_sub_r, subst_monotone; auto.
      }
+ right; eapply mctxvpure_monotone; [ | eassumption ].
  apply sum_sub_r, subst_monotone, map_monotone.
  apply sum_subset; [ | apply sum_subset ].
  - apply sum_sub_l; auto.
  - apply sum_sub_r, sum_sub_r; auto.
  - apply sum_sub_r, sum_sub_l, redr_monotone, sum_sub_r; auto.
+ left; left; apply Mk_map_id; right; left; apply Mk_redr_id; left.
  eapply ectxr_monotone; [ | eassumption ]; auto.
+ left; left; apply Mk_map_id; right; left; apply Mk_redr_id; right.
  eapply ectxrst_monotone; [ | eassumption ]; auto.
Qed.

Definition swap_01 {V : Set} (x : inc (inc V)) : inc (inc V) :=
  match x with
  | VZ        => VS VZ
  | VS VZ     => VZ
  | VS (VS y) => VS (VS y)
  end.

Lemma val_rel_subst (R : term_rel) (V : Set)
    (v₁ v₂ : value (inc V)) (w₁ w₂ : value V) :
  val_rel R _ v₁ v₂ →
  val_rel R _ w₁ w₂ →
  val_rel (subst (map R)) _ (v₁ {v↦ w₁ }) (v₂ {v↦ w₂ }).
Proof.
intros Hv Hw.
unfold val_rel; simpl; unfold val_rel in Hv.
apply Mk_map with (f := swap_01) in Hv.
apply Mk_subst with (v₁ := vshift w₁) (v₂ := vshift w₂) in Hv.
+ simpl in Hv.
  rewrite vmonad_map_map', vmonad_map_map' in Hv.
  erewrite vmonad_bind_map, vmonad_bind_map in Hv.
  - exact Hv.
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma val_rel_rst_subst (R : term_rel) (V : Set)
    (v₁ v₂ : value (inc V)) (w₁ w₂ : value V) :
  val_rel_rst R _ v₁ v₂ →
  val_rel R _ w₁ w₂ →
  val_rel_rst (subst (map R)) _ (v₁ {v↦ w₁ }) (v₂ {v↦ w₂ }).
Proof.
intros Hv Hw.
unfold val_rel_rst; simpl; unfold val_rel_rst in Hv.
apply Mk_map with (f := swap_01) in Hv.
apply Mk_subst with (v₁ := vshift w₁) (v₂ := vshift w₂) in Hv.
+ simpl in Hv.
  rewrite vmonad_map_map', vmonad_map_map' in Hv.
  erewrite vmonad_bind_map, vmonad_bind_map in Hv.
  - exact Hv.
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma ectx_rel_subst (R : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (v₁ v₂ : value V) :
  ectx_rel R _ E₁ E₂ →
  val_rel  R _ v₁ v₂ →
  ectx_rel (subst (map R)) _ (E₁ {E↦ v₁}) (E₂ {E↦ v₂}).
Proof.
intros HE Hv.
unfold ectx_rel; unfold ectx_rel in HE.
apply Mk_map with (f := swap_01) in HE.
apply Mk_subst with (v₁ := vshift v₁) (v₂ := vshift v₂) in HE.
+ rewrite map_eplug, map_eplug in HE; simpl in HE.
  rewrite emonad_map_map', emonad_map_map' in HE.
  rewrite bind_eplug, bind_eplug in HE; simpl in HE.
  erewrite emonad_bind_map, emonad_bind_map in HE; [ exact HE | | ].
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma ectx_rst_rel_subst (R : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (v₁ v₂ : value V) :
  ectx_rst_rel R _ E₁ E₂ →
  val_rel  R _ v₁ v₂ →
  ectx_rst_rel (subst (map R)) _ (E₁ {E↦ v₁}) (E₂ {E↦ v₂}).
Proof.
intros HE Hv.
unfold ectx_rst_rel; unfold ectx_rst_rel in HE.
apply Mk_map with (f := swap_01) in HE.
apply Mk_subst with (v₁ := vshift v₁) (v₂ := vshift v₂) in HE.
+ simpl in HE.
  rewrite map_eplug, map_eplug in HE; simpl in HE.
  rewrite emonad_map_map', emonad_map_map' in HE.
  rewrite bind_eplug, bind_eplug in HE; simpl in HE.
  erewrite emonad_bind_map, emonad_bind_map in HE; [ exact HE | | ].
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma mctx_val_rel_subst (R : term_rel) (V : Set)
    (F₁ F₂ : mctx (inc V)) (v₁ v₂ : value V) :
  mctx_val_rel R _ F₁ F₂ →
  val_rel  R _ v₁ v₂ →
  mctx_val_rel (subst (map R)) _ (F₁ {M↦ v₁}) (F₂ {M↦ v₂}).
Proof.
intros HF Hv.
unfold mctx_val_rel; unfold mctx_val_rel in HF.
apply Mk_map with (f := swap_01) in HF.
apply Mk_subst with (v₁ := vshift v₁) (v₂ := vshift v₂) in HF.
+ simpl in HF.
  rewrite map_mplug, map_mplug in HF; simpl in HF.
  rewrite mmonad_map_map', mmonad_map_map' in HF.
  rewrite bind_mplug, bind_mplug in HF; simpl in HF.
  erewrite mmonad_bind_map, mmonad_bind_map in HF; [ exact HF | | ].
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma mctx_rel_subst (R : term_rel) (V : Set)
    (F₁ F₂ : mctx (inc V)) (v₁ v₂ : value V) :
  mctx_rel R _ F₁ F₂ →
  val_rel  R _ v₁ v₂ →
  mctx_rel (subst (map R)) _ (F₁ {M↦ v₁}) (F₂ {M↦ v₂}).
Proof.
intros HF Hv.
destruct HF as [ E₁ E₂ HE | F₁ F₂ E₁ E₂ HE HF ].
+ rewrite mbind_pure, mbind_pure.
  constructor 1; apply ectx_rel_subst; assumption.
+ rewrite bind_mcomp, bind_mcomp; simpl.
  rewrite mbind_pure, mbind_pure; simpl.
  constructor 2.
  - apply ectx_rst_rel_subst; assumption.
  - apply mctx_val_rel_subst; assumption.
Qed.

Lemma val_rel_rst_inst (R : term_rel) {V : Set}
    (v₁ v₂ w₁ w₂ : value V) :
  val_rel_rst R V v₁ v₂ →
  val_rel R V w₁ w₂ →
  subst R V (tm_rst (tm_app v₁ w₁)) (tm_rst (tm_app v₂ w₂)).
Proof.
intros Hv Hw; unfold val_rel_rst in Hv.
apply Mk_subst with (v₁ := w₁) (v₂ := w₂) in Hv; [ | assumption ].
simpl in Hv; rewrite subst_vshift, subst_vshift in Hv.
assumption.
Qed.

Lemma subst_passive_evolution (R S : term_rel) :
  R ↣ R & S → subst R ⊆ passive_step (subst (map R)).
Proof.
intros HRS V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; split.
+ constructor.
  - apply Mk_map_id; assumption.
  - unfold val_rel; apply Mk_map_id; assumption.
+ intros w₀ Heq.
  destruct t₁ as [ w₁ | | ]; try discriminate.
  injection Heq; clear Heq; intro; subst.
  apply (progress_value HRS) in Ht.
  destruct Ht as [ w₂ [ Hred_t Hw ] ].
  exists (w₂ {v↦ v₂}); split.
  - change (red_rtc (t₂ {t↦v₂}) (w₂ {t↦v₂})).
    apply red_rtc_subst; assumption.
  - apply val_rel_subst; assumption.
Qed.

Lemma val_rel_sas_body_lam (R : term_rel) {V : Set}
    (E₁ E₂ : ectx (inc V)) (E₂' : ectx (inc V))
    (v₁ v₂ : value V) (w₁ w₂ : value (inc V)) :
  ectx_rst_rel R (inc V) E₁ E₂ →
  ectx_rel R (inc V) ectx_mt E₂' →
  val_rel R V v₁ v₂ →
  val_rel (subst (map R)) V (w₁ {v↦ v₁}) (w₂ {v↦ v₂}) →
  val_rel (sas_body_lam R) V
    (val_lam (tm_rst (eshift (E₁ {E↦ v₁}) $[ val_var VZ ])))
    (val_lam (tm_rst (eshift (ecomp (E₂ {E↦ v₂}) (E₂' {E↦ w₂ {v↦ v₂}}))
      $[ val_var VZ ]))).
Proof.
intros HE HE' Hv Hw.
econstructor; simpl;
  [ econstructor 2; [ apply red_beta | ]; constructor 1
  | econstructor 2; [ apply red_beta | ]; constructor 1
  | ].
simpl.
rewrite map_ecomp, ecomp_eplug.
rewrite map_eplug, map_eplug, map_eplug.
rewrite emonad_map_map', emonad_map_map', emonad_map_map'.
rewrite bind_eplug, bind_eplug, bind_eplug; simpl.
rewrite emonad_bind_map with (g₁ := @val_var _) (g₂ := @VS _);
    [ | reflexivity ]; rewrite emonad_bind_return'.
rewrite emonad_bind_map with (g₁ := @val_var _) (g₂ := @VS _);
    [ | reflexivity ]; rewrite emonad_bind_return'.
rewrite emonad_bind_map with (g₁ := @val_var _) (g₂ := @VS _);
    [ | reflexivity ]; rewrite emonad_bind_return'.
apply Mk_ectxrst.
+ apply ectx_rst_rel_map.
  apply ectx_rst_rel_subst; left; assumption.
+ match goal with
  | [ |- ?RR ?e1 ?e2 ] =>
    change (RR (eshift (ectx_mt {E↦ w₁ {v↦ v₁}}) $[ e1 ]) e2)
  end.
  apply Mk_map_id; apply ectx_rel_subst.
  - left; assumption.
  - right; assumption.
Qed.

Lemma subst_active_open_step (R S : term_rel) (V : Set)
  (v₁ v₂ : value V) (F₁ : mctx (inc V)) x (w₁ : value (inc V)) (t₁' : term V)
  (t₂ : term (inc V)) :
  (R ↣ R & S) →
  R _ (F₁ $$[ tm_app (val_var x) w₁ ]) t₂ →
  val_rel R _ v₁ v₂ →
  red (F₁ $$[ tm_app (val_var x) w₁ ] {t↦ v₁}) t₁' →
  ∃ t₂' : term V, red_rtc (t₂ {t↦ v₂}) t₂'
    ∧ subst_act' S _ t₁' t₂'.
Proof.
intros HRS Ht Hv Hred₁.
apply (progress_open HRS) in Ht.
destruct Ht as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
rewrite bind_mplug in Hred₁; simpl in Hred₁.
assert (Hv_S : val_rel S V v₁ v₂).
  { eapply val_rel_monotone; [ | eassumption ]; apply HRS. }
assert (Hw_sub : val_rel (subst (map S)) _ (w₁ {v↦ v₁}) (w₂ {v↦ v₂})).
  { apply val_rel_subst; assumption. }
apply red_mplug_appv in Hred₁.
destruct Hred₁ as [ [ f₁ [ Hlam ? ] ] | [ F [ E [ HFeq [ Hsft ? ] ] ] ] ];
    subst.
+ destruct x as [ | x ]; simpl in Hlam; [ subst | discriminate ].
  assert (Ht := Hv); unfold val_rel in Ht; simpl in Ht.
  eapply (progress_step HRS) in Ht; [ | apply red_beta ].
  destruct Ht as [ t₂' [ Hred₂' Ht' ] ].
  apply red_rtc_subst with (v := v₂) in Hred₂.
  rewrite bind_mplug in Hred₂; simpl in Hred₂.
  apply red_rtc_subst with (v := w₂ {v↦ v₂ }) in Hred₂'; simpl in Hred₂'.
  rewrite subst_vshift in Hred₂'.
  exists (F₂ {M↦ v₂} $$[ t₂' {t↦ w₂ {v↦ v₂}} ]); split.
  { eapply red_rtc_trans; [ eassumption | ].
    apply red_rtc_in_mctx; assumption.
  }
  apply SA_beta; apply Mk_mctxr.
  - eapply mctx_rel_subst in HF; [ | exact Hv_S ].
    eapply mctx_rel_monotone; [ | eassumption ].
    apply subst_monotone, sum_sub_l; auto.
  - rewrite tmonad_bind_map with (g₁ := @val_var _) (g₂ := λ x, x) in Ht';
      [ | intros [ | ]; reflexivity ].
    rewrite tmonad_map_id', tmonad_bind_return' in Ht'.
    constructor; [ left; apply Mk_map_id; assumption | ].
    eapply val_rel_monotone; [ | exact Hw_sub ].
    unfold trf_sum; auto.
+ destruct x as [ | x ]; simpl in Hsft; [ subst | discriminate ].
  destruct HF as [ E₁ E₂ | F₁ F₂ E₁ E₂ HE HF ].
  { rewrite mbind_pure in HFeq; symmetry in HFeq.
    apply mctx_pure_no_rst in HFeq; destruct HFeq.
  }
  rewrite bind_mcomp in HFeq; simpl in HFeq.
  rewrite mbind_pure in HFeq.
  apply mctx_rst_unique in HFeq; destruct HFeq; subst.
  assert (Ht := Hv); unfold val_rel in Ht; simpl in Ht.
  apply (progress_ctrl HRS ectx_mt) in Ht.
  destruct Ht as [ E₂' [ v₂' [ Hred₂' [ HE' Hv' ] ] ] ] .
  rewrite mcomp_mplug in Hred₂.
  apply red_rtc_subst with (v := v₂) in Hred₂.
  rewrite bind_mplug in Hred₂; simpl in Hred₂.
  rewrite bind_mplug in Hred₂; simpl in Hred₂.
  rewrite mbind_pure, mplug_pure in Hred₂.
  apply red_rtc_subst with (v := w₂ {v↦ v₂ }) in Hred₂'; simpl in Hred₂'.
  rewrite subst_vshift in Hred₂'.
  rewrite bind_eplug in Hred₂'; simpl in Hred₂'.
  eexists; split.
  { eapply red_rtc_trans; [ eassumption | ].
    apply red_rtc_in_mctx.
    eapply red_rtc_trans.
    { apply red_rtc_rst, red_rtc_in_ectx; eassumption. }
    rewrite <- ecomp_eplug; econstructor 2; [ | constructor 1 ].
    apply red_shift.
  }
  apply SA_shift; apply Mk_mctxvpure.
  - constructor.
  - constructor.
  - apply mctx_val_rel_subst; left; assumption.
  - apply val_rel_rst_inst.
    * match goal with
      | [ |- ?RR ?v1 ?v2 ] => change (RR (val_var VZ {v↦ v1}) v2)
      end.
      { apply Mk_map_id; right; left; apply val_rel_rst_subst.
      + left; assumption.
      + right; assumption.
      }
    * apply Mk_map_id; right; right.
      eapply val_rel_sas_body_lam; eassumption.
Qed.

Lemma subst_active_open_sub (R S : term_rel) (V : Set)
    (F₁ F₂ : mctx (inc V)) (w₁ w₂ : value (inc V))
    (t₂ : term (inc V)) (x : V) (v₂ : value V) :
  R ↣ R & S →
  mctx_rel S (inc V) F₁ F₂ →
  val_rel S (inc V) w₁ w₂ →
  val_rel R V (val_var x) v₂ →
  red_rtc t₂ (F₂ $$[ tm_app (val_var VZ) w₂ ]) →
  ∃ F₂' (v₂' : value _),
             red_rtc (t₂ {t↦ v₂}) (F₂' $$[ tm_app (val_var x) v₂' ])
           ∧ mctx_rel (subst_act' S) _ (F₁ {M↦ val_var x}) F₂'
           ∧ val_rel  (subst_act' S) _ (w₁ {v↦ val_var x}) v₂'.
Proof.
intros HRS HF Hw Hv Hred.
apply red_rtc_subst with (v := v₂) in Hred.
rewrite bind_mplug in Hred; simpl in Hred.
assert (Hx := Hv); unfold val_rel in Hx.
apply (progress_open HRS ectx_mt) in Hx.
destruct Hx as [ F₂' [ u₂ [ Hred' [ HF' Hu ] ] ] ].
apply red_rtc_subst with (v := w₂ {v↦ v₂}) in Hred'.
rewrite bind_mplug in Hred'; simpl in Hred'.
rewrite subst_vshift in Hred'.
exists (mcomp (F₂ {M↦ v₂}) (F₂' {M↦ w₂ {v↦ v₂}})).
exists (u₂ {v↦ w₂ {v↦ v₂}}).
split; [ | split ].
+ rewrite mcomp_mplug.
  eapply red_rtc_trans; [ eassumption | ].
  apply red_rtc_in_mctx; assumption.
+ inversion HF' as [ E₁' E₂' HE' | ]; subst;
    [ | exfalso; eapply mctx_pure_no_rst with (E' := ectx_mt); 
        eassumption ].
  destruct E₁'; try discriminate.
  destruct HF as [ E₁ E₂ HE | F₁ F₂ E₁ E₂ HE HF ].
  - rewrite mbind_pure, mbind_pure, mbind_pure, mcomp_pure.
    constructor 1.
    rewrite <- ecomp_mt with (E := E₁ {E↦ _}).
    match goal with
    | [ |- ?RR (ecomp ?E1 _) ?E2 ] =>
      change (RR (ecomp E1 (ectx_mt {E↦ w₁ {v↦ val_var x}})) E2)
    end.
    eapply ectx_rel_monotone;
      [ intros; apply SA_comp; eassumption | ].
    apply ectx_rel_comp; apply ectx_rel_subst.
    * eapply ectx_rel_monotone; [ | eassumption ].
      apply sum_sub_l; auto.
    * eapply val_rel_monotone; [ | eassumption ].
      apply sum_sub_l, HRS.
    * eapply ectx_rel_monotone; [ | eassumption ].
      apply sum_sub_l; auto.
    * eapply val_rel_monotone;
        [ | apply val_rel_subst; [ eassumption | ] ];
        [ apply sum_sub_r; auto | ].
      eapply val_rel_monotone; [ | eassumption ].
      apply HRS.
  - rewrite bind_mcomp, bind_mcomp, mcomp_assoc; simpl.
    rewrite mbind_pure, mbind_pure, mbind_pure, mcomp_pure.
    constructor 2.
    * rewrite <- ecomp_mt with (E := E₁ {E↦ _}).
      match goal with
      | [ |- ?RR (ecomp ?E1 _) ?E2 ] =>
        change (RR (ecomp E1 (ectx_mt {E↦ w₁ {v↦ val_var x}})) E2)
      end.
      eapply ectx_rst_rel_monotone;
        [ intros; apply SA_comp_rst; eassumption | ].
      { apply ectx_rst_rel_comp;
          [ apply ectx_rst_rel_subst | apply ectx_rel_subst ].
      + eapply ectx_rst_rel_monotone; [ | eassumption ].
        apply sum_sub_l; auto.
      + eapply val_rel_monotone; [ | eassumption ].
        apply sum_sub_l, HRS.
      + eapply ectx_rel_monotone; [ | eassumption ].
        apply sum_sub_l; auto.
      + eapply val_rel_monotone;
          [ | apply val_rel_subst; [ eassumption | ] ];
          [ apply sum_sub_r; auto | ].
        eapply val_rel_monotone; [ | eassumption ].
        apply HRS.
      }
    * apply SA_subst_map, mctx_val_rel_subst; [ assumption | ].
      eapply val_rel_monotone; [ | eassumption ].
      apply HRS.
+ change (val_rel (subst_act' S) V
    ((val_var VZ) {v↦ w₁ {v↦ val_var x}})
    (u₂           {v↦ w₂ {v↦ v₂}})).
  eapply val_rel_monotone; [ | apply val_rel_subst ];
    [ | | eapply val_rel_monotone; 
          [ | apply val_rel_subst; [ eassumption | ] ] ].
  - intros; apply SA_subst_map2; eassumption.
  - eapply val_rel_monotone; [ | eassumption ].
    unfold trf_sum; auto.
  - intros; right; assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
Qed.

Lemma subst_active_open_old (R S : term_rel) (V : Set)
    (F₁ F₂ : mctx (inc V)) (w₁ w₂ : value (inc V)) (v₁ v₂ : value V)
    (t₂ : term (inc V)) (x : V) :
  R ↣ R & S →
  mctx_rel S (inc V) F₁ F₂ →
  val_rel S (inc V) w₁ w₂ →
  val_rel R V v₁ v₂ →
  red_rtc t₂ (F₂ $$[ tm_app (val_var (VS x)) w₂ ]) →
  ∃ F₂' (v₂' : value _),
             red_rtc (t₂ {t↦ v₂}) (F₂' $$[ tm_app (val_var x) v₂' ])
           ∧ mctx_rel (subst_act' S) _ (F₁ {M↦ v₁}) F₂'
           ∧ val_rel  (subst_act' S) _ (w₁ {v↦ v₁}) v₂'.
Proof.
intros HRS HF Hw Hv Hred.
apply red_rtc_subst with (v := v₂) in Hred.
rewrite bind_mplug in Hred; simpl in Hred.
exists (F₂ {M↦ v₂}); exists (w₂ {v↦ v₂}); split; [ | split ].
+ assumption.
+ eapply mctx_rel_monotone; [ | apply mctx_rel_subst; [ eassumption | ] ].
  - intros; apply SA_subst_map; assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
+ eapply val_rel_monotone; [ | apply val_rel_subst; [ eassumption | ] ].
  - intros; apply SA_subst_map; assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
Qed.

Lemma subst_active_open_ctrl (R S : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (w₁ w₂ : value (inc V)) (v₂ : value V)
    (t₂ : term (inc V)) :
  R ↣ R & S →
  ectx_rel S (inc V) E₁ E₂ →
  val_rel S (inc V) w₁ w₂ →
  val_rel R V val_sft v₂ →
  red_rtc t₂ (E₂ $$[ tm_app (val_var VZ) w₂ ]) →
  ∃ E₂' (v₂' : value _),
             red_rtc (t₂ {t↦ v₂}) (E₂' $[ tm_app val_sft v₂' ])
           ∧ ectx_rel (subst_act' S) _ (E₁ {E↦ val_sft}) E₂'
           ∧ val_rel_rst (subst_act' S) _ (w₁ {v↦ val_sft}) v₂'.
Proof.
intros HRS HE Hw Hv Hred; rewrite mplug_pure in Hred.
assert (Ht := Hv); unfold val_rel in Ht.
apply (progress_ctrl HRS ectx_mt) in Ht.
destruct Ht as [ E₂' [ v₂' [ Hred' [ HE' Hv' ] ] ] ].
apply red_rtc_subst with (v := v₂) in Hred.
rewrite bind_eplug in Hred; simpl in Hred.
apply red_rtc_subst with (v := w₂ {v↦ v₂}) in Hred'; simpl in Hred'.
rewrite subst_vshift, bind_eplug in Hred'; simpl in Hred'.
exists (ecomp (E₂ {E↦ v₂}) (E₂' {E↦ w₂ {v↦ v₂}}));
  exists (v₂' {v↦ w₂ {v↦ v₂}}).
split; [ | split ].
+ eapply red_rtc_trans; [ eassumption | ].
  rewrite ecomp_eplug; apply red_rtc_in_ectx; assumption.
+ rewrite <- ecomp_mt with (E := E₁ {E↦ _}).
  match goal with
  | [ |- ?RR (ecomp ?E1 _) ?E2 ] =>
    change (RR (ecomp E1 (ectx_mt {E↦ w₁ {v↦ val_sft}})) E2)
  end.
  eapply ectx_rel_monotone;
    [ intros; apply SA_comp; eassumption | ].
  apply ectx_rel_comp; apply ectx_rel_subst.
  - eapply ectx_rel_monotone; [ | eassumption ].
    apply sum_sub_l; auto.
  - eapply val_rel_monotone; [ | eassumption ].
    apply sum_sub_l, HRS.
  - eapply ectx_rel_monotone; [ | eassumption ].
    apply sum_sub_l; auto.
  - eapply val_rel_monotone;
      [ | apply val_rel_subst; [ eassumption | ] ];
      [ apply sum_sub_r; auto | ].
    eapply val_rel_monotone; [ | eassumption ].
    apply HRS.
+ change (val_rel_rst (subst_act' S) V
    ((val_var VZ) {v↦ w₁ {v↦ val_sft}})
    (v₂'          {v↦ w₂ {v↦ v₂}})).
  eapply val_rel_rst_monotone; [ | apply val_rel_rst_subst ];
    [ | | eapply val_rel_monotone; 
          [ | apply val_rel_subst; [ eassumption | ] ] ].
  - intros; apply SA_subst_map2; eassumption.
  - eapply val_rel_rst_monotone; [ | eassumption ].
    unfold trf_sum; auto.
  - intros; right; assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
Qed.

Lemma subst_active_evolution' (R S : term_rel) :
  R ↣ R & S →
  subst R ⊆ active_step (subst_act' S).
Proof.
intros HRS V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; split.
+ apply SA_subst; constructor.
  - apply (progress_sub_active HRS); assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
+ destruct (classify t₁) as [ v | t₁ t₁' Hred₁ | F₁ x w₁ | E₁ w₁ ].
  - intros ? Hred; inversion Hred.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    apply red_subst with (v := v₁) in Hred₁.
    intros t₀ Hred'.
    eapply red_determ in Hred'; [ | exact Hred₁ ]; subst.
    exists (t₂' {t↦ v₂}); split.
    * apply red_rtc_subst; assumption.
    * apply SA_subst; constructor; [ assumption | ].
      eapply val_rel_monotone; [ | eassumption ].
      apply (progress_sub_active HRS).
  - intros; eapply subst_active_open_step; eassumption.
  - intros t₁' Hred; rewrite bind_eplug in Hred; simpl in Hred.
    apply ctrl_is_stuck in Hred; destruct Hred.
+ destruct (classify t₁) as [ v | t₁ t₁' Hred₁ | F₁ x w₁ | E₁ w₁ ].
  - intros E x w Heq; exfalso; simpl in Heq.
    destruct E; discriminate.
  - intros E x v Heq; exfalso.
    apply (red_subst _ _ v₁) in Hred₁; rewrite Heq in Hred₁.
    apply open_is_stuck in Hred₁; assumption.
  - apply (progress_open HRS) in Ht.
    destruct Ht as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
    intros F₁' z w₁' Heq.
    rewrite bind_mplug in Heq; simpl in Heq.
    destruct x as [ | x ]; simpl in Heq;
      [ destruct v₁ as [ y | t₁ | ]; simpl in Heq | ].
    * apply open_stuck_unique in Heq.
      destruct Heq as [ ? [ ? ? ] ]; subst.
      eapply subst_active_open_sub; eassumption.
    * exfalso; eapply (open_is_stuck F₁' z w₁').
      rewrite <- Heq; apply red_in_mctx, red_beta.
    * { exfalso; destruct (mctx_case (F₁ {M↦ val_sft})) as
          [ [ E HE ] | [ F [ E Heq' ] ] ].
      + rewrite HE, mplug_pure in Heq.
        apply ctrl_is_not_open in Heq; assumption.
      + rewrite Heq', mcomp_mplug in Heq; simpl in Heq.
        rewrite mplug_pure in Heq.
        eapply open_is_stuck; rewrite <- Heq.
        apply red_in_mctx, red_shift.
      }
    * apply open_stuck_unique in Heq.
      destruct Heq as [ ? [ ? ? ] ]; subst.
      eapply subst_active_open_old; eassumption.
  - intros F₁ x w Heq; exfalso.
    rewrite bind_eplug in Heq; simpl in Heq.
    apply ctrl_is_not_open in Heq; assumption.
+ destruct (classify t₁) as [ v | t₁ t₁' Hred₁ | F₁ x w₁ | E₁ w₁ ].
  - intros E₁ w Heq; destruct E₁; discriminate.
  - intros E₁ w₁ Heq.
    apply red_subst with (v := v₁) in Hred₁; rewrite Heq in Hred₁.
    apply ctrl_is_stuck in Hred₁; destruct Hred₁.
  - intros E₁ v₁' Heq.
    rewrite bind_mplug in Heq; simpl in Heq.
    apply (progress_open HRS) in Ht.
    destruct Ht as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
    destruct x as [ | x ]; [ destruct v₁ as [ z | t | ] | ]; simpl in Heq.
    * apply open_is_not_ctrl in Heq; destruct Heq.
    * exfalso; eapply (ctrl_is_stuck E₁ v₁').
      rewrite <- Heq; apply red_in_mctx, red_beta.
    * { destruct HF as [ E₁' E₂' HE' | F₁ F₂ E₁' E₂' HE HF ].
      + rewrite mbind_pure, mplug_pure in Heq.
        apply ctrl_stuck_unique in Heq; destruct Heq; subst.
        eapply subst_active_open_ctrl; eassumption.
      + rewrite bind_mcomp, mcomp_mplug in Heq; simpl in Heq.
        rewrite mbind_pure, mplug_pure in Heq.
        exfalso; eapply (ctrl_is_stuck E₁ v₁').
        rewrite <- Heq; apply red_in_mctx, red_shift.
      }
    * apply open_is_not_ctrl in Heq; destruct Heq.
  - intros E₁' v₁' Heq; rewrite bind_eplug in Heq; simpl in Heq.
    apply ctrl_stuck_unique in Heq.
    destruct Heq; subst.
    eapply val_rel_monotone in Hv;
      [ | apply (progress_sub_active HRS) ].
    apply (progress_ctrl HRS) in Ht.
    destruct Ht as [ E₂ [ w₂ [ Hred [ HE Hw ] ] ] ].
    exists (E₂ {E↦ v₂}); exists (w₂ {v↦ v₂}).
    split; [ | split ].
    * apply red_rtc_subst with (v := v₂) in Hred.
      rewrite bind_eplug in Hred; assumption.
    * apply SA_subst_map, ectx_rel_subst; assumption.
    * apply SA_subst_map, val_rel_rst_subst; assumption.
Qed.

Lemma subst_active_evolution (R S : term_rel) :
  R ↣ R & S →
  subst R ⊆ active_step (subst_act S).
Proof.
intros HRS V t₁ t₂ Ht.
eapply active_step_monotone; [ apply subst_act_repr | ].
eapply subst_active_evolution'; eassumption.
Qed.

Lemma subst_evolution : subst ↝ (subst ◦ map) & subst_act.
Proof.
intros R S HRS; split.
+ eapply subst_passive_evolution; eassumption.
+ eapply subst_active_evolution; eassumption.
Qed.