Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import Reduction.

Lemma sft_passive_evolution {R Q S : term_rel} :
  R ↣ Q & S → sft R ⊆ passive_step ((sft ∪ sft2) Q).
Proof.
intros HRQS V _ _ [ ]; split.
+ left; constructor.
+ intros v₁ Heq; injection Heq; clear Heq; intro Heq; subst.
  exists val_sft; split; [ constructor 1 | ].
  unfold val_rel; right; constructor.
Qed.

Lemma sft_active_evolution {R Q S : term_rel} :
  R ↣ Q & S → sft R ⊆ active_step (sft S).
Proof.
intros HRQS V _ _ [ ]; split.
+ constructor.
+ intros ? Hred; inversion Hred.
+ intros F₁ x v₁ Heq; destruct F₁; discriminate.
+ intros E₁ t₁' Heq; destruct E₁; discriminate.
Qed.

Lemma sft_evolution : sft !↝ (sft ∪ sft2) & sft.
Proof.
intros R Q S HRQS; split.
+ apply (sft_passive_evolution HRQS).
+ apply (sft_active_evolution HRQS).
Qed.

Lemma sft2_passive_evolution {R Q S : term_rel} :
  R ↣ Q & S → sft2 R ⊆ passive_step (sft2 Q).
Proof.
intros HRQS V _ _ [ x ]; split.
+ constructor.
+ intros; discriminate.
Qed.

Lemma sft2_active_evolution {R Q S : term_rel} :
  R ↣ Q & S → sft2 R ⊆ active_step ((sft2 ∪ (var ∪ (rst ◦ var2))) S).
Proof.
intros HRQS V _ _ [ ]; split.
+ left; constructor.
+ intros ? Hred; apply (ctrl_is_stuck ectx_mt) in Hred; destruct Hred.
+ intros F₁ z v₁ Heq.
  apply (ctrl_is_not_open _ _ _ _ ectx_mt) in Heq; destruct Heq.
+ intros E₁ w₁ Heq.
  apply (ctrl_stuck_unique ectx_mt) in Heq; destruct Heq; subst.
  exists ectx_mt; exists (val_var x); simpl; split; [ | split ].
  - constructor 1.
  - right; left; constructor.
  - right; right; apply Mk_rst; constructor.
Qed.

Lemma sft2_evolution : sft2 !↝ sft2 & (sft2 ∪ (var ∪ (rst ◦ var2))).
Proof.
intros R Q S HRQS; split.
+ eapply (sft2_passive_evolution HRQS).
+ apply (sft2_active_evolution HRQS).
Qed.
