Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import LangProperties Reduction.
Require Import Monotonicity.

Lemma redr_passive_evolution {R Q S : term_rel} :
  R ↣ Q & S → redr R ⊆ passive_step ((redr ∪ id) Q).
Proof.
intros HRQS V t₁ t₂ [ s₁ s₂ Hred₁ Hred₂ Hs ]; split.
+ left; econstructor; [ eassumption | eassumption | ].
  apply (progress_sub_passive HRQS); assumption.
+ intros v₁ Heq; subst.
  destruct Hred₁ as [ | ? ? Hred ]; [ | inversion Hred ].
  apply (progress_value HRQS) in Hs; destruct Hs as [ v₂ [ Hred' Hv ] ].
  exists v₂; split.
  - eapply red_rtc_trans; eassumption.
  - right; assumption.
Qed.

Lemma redr_active_evolution {R Q S : term_rel} :
  R ↣ Q & S → redr R ⊆ active_step ((redr ∪ id) S).
Proof.
intros HRQS V t₁ t₂ [ s₁ s₂ Hred₁ Hred₂ Hs ]; split.
+ left; econstructor; [ eassumption | eassumption | ].
  apply (progress_sub_active HRQS); assumption.
+ destruct Hred₁ as [ | ? ? Hred₁ Hred₁' ].
  - intros t₁' Hred.
    eapply (progress_step HRQS) in Hs; [ | eassumption ].
    destruct Hs as [ t₂' [ Hred' Ht' ] ].
    exists t₂'; split.
    * eapply red_rtc_trans; eassumption.
    * right; assumption.
  - intros t₁' Hred; eapply red_determ in Hred; [ | exact Hred₁ ]; subst.
    exists t₂; split.
    * constructor 1.
    * { left; econstructor.
      + eassumption.
      + eassumption.
      + apply (progress_sub_active HRQS); assumption.
      }
+ intros F₁ x v₁ Heq.
  destruct Hred₁ as [ | ? ? Hred ].
  - subst; apply (progress_open HRQS) in Hs.
    destruct Hs as [ F₂ [ v₂ [ Hred' [ HF Hv ] ] ] ].
    exists F₂; exists v₂; split; [ | split ].
    * eapply red_rtc_trans; eassumption.
    * eapply mctx_rel_monotone; [ | eassumption ].
      apply sum_sub_r; auto.
    * right; assumption.
  - rewrite Heq in Hred; apply open_is_stuck in Hred; destruct Hred.
+ intros E₁ v₁ Heq.
  destruct Hred₁ as [ | ? ? Hred ].
  - subst; apply (progress_ctrl HRQS) in Hs.
    destruct Hs as [ E₂ [ v₂ [ Hred' [ HE Hv ] ] ] ].
    exists E₂; exists v₂; split; [ | split ].
    * eapply red_rtc_trans; eassumption.
    * eapply ectx_rel_monotone; [ | eassumption ].
      apply sum_sub_r; auto.
    * right; assumption.
  - rewrite Heq in Hred; apply ctrl_is_stuck in Hred; destruct Hred.
Qed.

Lemma redr_evolution : redr !↝ (redr ∪ id) & (redr ∪ id).
Proof.
intros R Q S HRQS; split.
+ apply (redr_passive_evolution HRQS).
+ apply (redr_active_evolution HRQS).
Qed.