Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques Monotonicity.
Require Import LangProperties Reduction.
Require Import UpToSubst CtxComp.

Definition mctxvpure_act : term_rel → term_rel :=
  ((mctxvpure ◦ map) ∪ subst_act) ∪ id.

Lemma mctxvpure_passive_evolution (R S : term_rel) :
  R ↣ R & S →
  mctxvpure R ⊆ passive_step ((mctxvpure ∪ (subst ◦ map)) R).
Proof.
intros HRS V _ _ [ F₁ F₂ t₁ t₂ Hp₁ Hp₂ HF Ht ]; split.
+ left; constructor; assumption.
+ intros v₁ Heq; destruct F₁; try discriminate.
  simpl in Heq; subst.
  apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₁ Hv ] ].
  unfold mctx_val_rel in HF; simpl in HF.
  apply (progress_value HRS) in HF; destruct HF as [ u [ Hred₂ Hu ] ].
  apply red_rtc_subst with (v := v₂) in Hred₂.
  rewrite bind_mplug in Hred₂; simpl in Hred₂.
  rewrite subst_mshift in Hred₂.
  exists (u {v↦ v₂}); split.
  - eapply red_rtc_trans; [ | eassumption ].
    apply red_rtc_in_mctx; assumption.
  - apply val_rel_subst with (w₁ := v₁) (w₂ := v₂) in Hu; [ | assumption ].
    simpl in Hu.
    eapply val_rel_monotone; [ | eassumption ].
    unfold trf_sum; auto.
Qed.

Lemma mctxvpure_active_evolution (R S : term_rel) :
  R ↣ R & S →
  mctxvpure R ⊆ active_step (mctxvpure_act S).
Proof.
intros HRS V _ _ [ F₁ F₂ t₁ t₂ Hp₁ Hp₂ HF Ht ]; split.
+ left; left; constructor; [ assumption | assumption | | ].
  - eapply mctx_val_rel_monotone; [ | eassumption ].
    intros; apply Mk_map_id; apply HRS; assumption.
  - apply Mk_map_id; apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁' x v₁ | E₁ v₁ ].
  - intros t₁' Hred.
    apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₂ Hv ] ].
    unfold mctx_val_rel in HF.
    apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HF; [ | assumption ].
    repeat rewrite bind_mplug in HF; simpl in HF.
    repeat rewrite subst_mshift in HF.
    assert (HRS' := HRS); apply subst_evolution in HRS'.
    eapply (progress_step HRS') in HF; [ | eassumption ].
    destruct HF as [ t₂' [ Hred₂' Ht' ] ].
    exists t₂'; split.
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_in_mctx; assumption.
    * left; right; assumption.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    intros r Hred'.
    eapply red_determ in Hred'; [ | apply red_in_mctx; eassumption ]; subst.
    exists (F₂ $$[ t₂' ]); split.
    * apply red_rtc_in_mctx; assumption.
    * { left; left; constructor.
      + eapply red_pure; [ | eassumption ]; assumption.
      + eapply red_rtc_pure; [ | eassumption ]; assumption.
      + eapply mctx_val_rel_monotone; [ | eassumption ].
        intros; apply Mk_map_id; apply (progress_sub_active HRS); assumption.
      + apply Mk_map_id; assumption.
      }
  - intros ? Hred; rewrite <- mcomp_mplug in Hred.
    apply open_is_stuck in Hred; destruct Hred.
  - destruct E₁; inversion Hp₁.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁' x v₁ | E₁ v₁ ].
  - intros G₁ x w₁ Heq.
    apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₂ Hv ] ].
    unfold mctx_val_rel in HF.
    apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HF; [ | assumption ].
    repeat rewrite bind_mplug in HF; simpl in HF.
    repeat rewrite subst_mshift in HF.
    rewrite Heq in HF.
    assert (HRS' := HRS); apply subst_evolution in HRS'.
    eapply (progress_open HRS') in HF.
    destruct HF as [ G₂ [ w₂ [ Hred₂' [ HG Hw ] ] ] ].
    exists G₂; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_in_mctx; assumption.
    * eapply mctx_rel_monotone; [ | eassumption ].
      apply sum_sub_l, sum_sub_r; auto.
    * left; right; assumption.
  - intros F₁' x v₁ Heq.
    apply red_in_mctx with (F := F₁) in Hred; rewrite Heq in Hred.
    apply open_is_stuck in Hred; destruct Hred.
  - eapply (progress_open HRS) in Ht.
    destruct Ht as [ F₂' [ v₂ [ Hred₂ [ HF' Hv ] ] ] ].
    intros G₁ z w₂ Heq; symmetry in Heq.
    rewrite <- mcomp_mplug in Heq; apply open_stuck_unique in Heq.
    destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (mcomp F₂ F₂'); exists v₂; split; [ | split ].
    * rewrite mcomp_mplug; apply red_rtc_in_mctx; assumption.
    * destruct F₁'; inversion_clear Hp₁.
      eapply red_rtc_pure in Hp₂; [ | eassumption ].
      destruct F₂'; inversion_clear Hp₂.
      { eapply mctx_rel_monotone;
          [ | apply mctx_val_rel_comp_mctxvpure; [ | eassumption ] ].
      + apply sum_subset.
        - apply sum_sub_r; auto.
        - apply sum_sub_l, sum_sub_l; auto.
      + apply (progress_sub_active HRS); assumption.
      }
    * eapply val_rel_monotone; [ | eassumption ].
      apply sum_sub_r; auto.
  - destruct E₁; inversion Hp₁.
+ intros E₁ w₁ Heq.
  destruct t₁ as [ v₁ | | ]; inversion Hp₁; subst.
  - apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₂ Hv ] ].
    unfold mctx_val_rel in HF.
    apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HF; [ | assumption ].
    repeat rewrite bind_mplug in HF; simpl in HF.
    repeat rewrite subst_mshift in HF.
    rewrite Heq in HF.
    assert (HRS' := HRS); apply subst_evolution in HRS'.
    eapply (progress_ctrl HRS') in HF.
    destruct HF as [ E₂ [ w₂ [ Hred₂' [ HE Hw ] ] ] ].
    exists E₂; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_in_mctx; assumption.
    * eapply ectx_rel_monotone; [ | eassumption ].
      apply sum_sub_l, sum_sub_r; auto.
    * left; right; assumption.
  - apply ctrl_not_mplug_rst in Heq; destruct Heq.
Qed.

Lemma mctxvpure_evolution :
  mctxvpure ↝ (mctxvpure ∪ (subst ◦ map)) & mctxvpure_act.
Proof.
intros R S HRS; split.
+ apply (mctxvpure_passive_evolution _ _ HRS).
+ apply mctxvpure_active_evolution; assumption.
Qed.