Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import Reduction LangProperties Monotonicity.
Require Import UpToMap UpToSubst CtxComp.

Inductive ectxrst_act' (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
| ERA_id    : R V t₁ t₂ →
    ectxrst_act' R V t₁ t₂
| ERA_ectxrst : ectxrst R V t₁ t₂ →
    ectxrst_act' R V t₁ t₂
| ERA_subst_act : subst_act R V t₁ t₂ →
    ectxrst_act' R V t₁ t₂
| ERA_shift : (subst ◦ (id ∪ (redr ◦ ectxrst ◦ map))) R V t₁ t₂ →
    ectxrst_act' R V t₁ t₂
| ERA_comp : (id ∪ (var ∪ (ectxrst ◦ map))) R V t₁ t₂ →
    ectxrst_act' R V t₁ t₂
.

Definition ectxrst_act : term_rel → term_rel :=
  ((id ∪ subst) ◦ (id ∪ (redr ◦ ectxrst ◦ map))) ∪ (var ∪ subst_act).

Lemma ectxrst_act_repr (R : term_rel) :
  ectxrst_act' R ⊆ ectxrst_act R.
Proof.
intros V t₁ t₂ H; destruct H; unfold ectxrst_act.
+ left; left; left; assumption.
+ left; left; right; apply Mk_redr_id.
  eapply ectxrst_monotone; [ | eassumption ].
  apply map_id_monotone; auto.
+ right; right; assumption.
+ left; right; assumption.
+ destruct H as [ H | [ H | H ] ].
  - left; left; left; assumption.
  - right; left; assumption.
  - left; left; right; apply Mk_redr_id; assumption.
Qed.

Lemma ectxrst_passive_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxrst R ⊆ passive_step (ectxrst R).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ constructor; assumption.
+ intros v₁ Heq; destruct E₁; discriminate.
Qed.

Lemma ectxrst_active_val_red (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (t₁' : term V) (v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rst_rel R _ E₁ E₂ →
  R _ v₁ t₂ →
  red (tm_rst (E₁ $[ v₁ ])) t₁' →
  ∃ t₂' : term V, red_rtc (tm_rst (E₂ $[ t₂])) t₂' ∧ ectxrst_act' S V t₁' t₂'.
Proof.
intros HRS HE Ht₂ Hred.
apply (progress_value HRS) in Ht₂.
destruct Ht₂ as [ v₂ [ Hred₂ Hv ] ].
unfold ectx_rst_rel in HE.
apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
simpl in HE.
repeat rewrite bind_eplug in HE; simpl in HE.
repeat rewrite subst_eshift in HE.
assert (HRS' := HRS); apply subst_evolution in HRS'.
eapply (progress_step HRS') in HE; [ | eassumption ].
destruct HE as [ t₂' [ Hred₂' Ht' ] ].
exists t₂'; split.
+ eapply red_rtc_trans; [ | eassumption ].
  apply red_rtc_rst, red_rtc_in_ectx; assumption.
+ apply ERA_subst_act; assumption.
Qed.

Lemma ectxrst_active_ctrl_red (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (t₁' : term V) (E₁' : ectx V) (v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rst_rel R _ E₁ E₂ →
  R _ (E₁' $[ tm_app val_sft v₁ ]) t₂ →
  red (tm_rst (E₁ $[ E₁' $[ tm_app val_sft v₁ ] ])) t₁' →
  ∃ t₂' : term V, red_rtc (tm_rst (E₂ $[ t₂])) t₂' ∧ ectxrst_act' S V t₁' t₂'.
Proof.
intros HRS HE Ht₂ Hred.
apply (progress_ctrl HRS) in Ht₂.
destruct Ht₂ as [ E₂' [ v₂ [ Hred₂ [ HE' Hv ] ] ] ].
rewrite <- ecomp_eplug in Hred.
eapply red_determ in Hred; [ | apply red_shift ]; subst.
eexists; split.
{ eapply red_rtc_trans; [ apply red_rtc_rst, red_rtc_in_ectx; eassumption | ].
  rewrite <- ecomp_eplug; econstructor 2; [ | constructor 1 ].
  apply red_shift.
}
apply ERA_shift; apply val_rel_rst_inst.
+ left; assumption.
+ unfold val_rel; simpl; right; econstructor;
    [ econstructor 2; [ | constructor 1 ]; apply red_beta
    | econstructor 2; [ | constructor 1 ]; apply red_beta
    | ]; simpl.
  rewrite map_eplug, map_eplug, emonad_map_map', emonad_map_map'; simpl.
  rewrite bind_eplug, bind_eplug; simpl.
  rewrite emonad_bind_map with (g₁ := @val_var _) (g₂ := @VS _);
    [ | reflexivity ]; rewrite emonad_bind_return'.
  rewrite emonad_bind_map with (g₁ := @val_var _) (g₂ := @VS _);
    [ | reflexivity ]; rewrite emonad_bind_return'.
  rewrite map_ecomp, map_ecomp, ecomp_eplug, ecomp_eplug.
  constructor.
  - eapply ectx_rst_rel_map, ectx_rst_rel_monotone; [ | eassumption ].
    apply HRS.
  - apply Mk_map_id; assumption.
Qed.

Lemma ectxrst_active_val_open (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (F₁ : mctx V) (x : V) (w₁ v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rst_rel R _ E₁ E₂ →
  R _ v₁ t₂ →
  tm_rst (E₁ $[ v₁ ]) = F₁ $$[ tm_app (val_var x) w₁ ] →
  ∃ (F₂ : mctx V) (w₂ : value V),
    red_rtc (tm_rst (E₂ $[ t₂])) (F₂ $$[ tm_app (val_var x) w₂ ])
    ∧ mctx_rel (ectxrst_act' S) V F₁ F₂
    ∧ val_rel (ectxrst_act' S) V w₁ w₂.
Proof.
intros HRS HE Ht₂ Heq.
apply (progress_value HRS) in Ht₂.
destruct Ht₂ as [ v₂ [ Hred Hv ] ].
unfold ectx_rst_rel in HE.
apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
simpl in HE; rewrite bind_eplug, bind_eplug in HE; simpl in HE.
rewrite subst_eshift, subst_eshift, Heq in HE.
assert (HRS' := HRS); apply subst_evolution in HRS'.
eapply (progress_open HRS') in HE.
destruct HE as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
exists F₂; exists w₂; split; [ | split ].
+ eapply red_rtc_trans; [ | eassumption ].
  apply red_rtc_rst, red_rtc_in_ectx; assumption.
+ eapply mctx_rel_monotone; [ | eassumption ].
  apply ERA_subst_act.
+ eapply val_rel_monotone; [ | eassumption ].
  apply ERA_subst_act.
Qed.

Lemma ectxrst_active_evolution' (R S : term_rel) :
  R ↣ R & S →
  ectxrst R ⊆ active_step (ectxrst_act' S).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ apply ERA_ectxrst; constructor.
  - eapply ectx_rst_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
  - apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁' v₁ ].
  - intro; eapply ectxrst_active_val_red; eassumption.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    intros r Hred'.
    eapply red_determ in Hred';
      [ | apply red_rst, red_in_ectx; eassumption ]; subst.
    exists (tm_rst (E₂ $[ t₂' ])); split.
    * apply red_rtc_rst, red_rtc_in_ectx; assumption.
    * apply ERA_ectxrst; constructor; [ | assumption ].
      eapply ectx_rst_rel_monotone; [ | eassumption ].
      apply (progress_sub_active HRS).
  - intros ? Hred; rewrite <- mplug_pure, <- mcomp_mplug in Hred.
    apply (open_is_stuck (mctx_rst _)) in Hred; destruct Hred.
  - intro; eapply ectxrst_active_ctrl_red; eassumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁' v₁ ].
  - intros ? ? ?; eapply ectxrst_active_val_open; eassumption.
  - intros F₁ x v₁ Heq.
    apply red_in_ectx with (E := E₁) in Hred; apply red_rst in Hred.
    rewrite Heq in Hred; apply open_is_stuck in Hred; destruct Hred.
  - eapply (progress_open HRS) in Ht.
    destruct Ht as [ F₂ [ v₂ [ Hred₂ [ HF Hv ] ] ] ].
    intros G₁ z w₂ Heq; symmetry in Heq.
    rewrite <- mplug_pure, <- mcomp_mplug in Heq.
    apply (open_stuck_unique _ (mctx_rst _)) in Heq.
    destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (mctx_rst (mcomp E₂ F₂)); exists v₂; split; [ | split ].
    * simpl; apply red_rtc_rst; rewrite mcomp_mplug, mplug_pure.
      apply red_rtc_in_ectx; assumption.
    * eapply mctx_rel_monotone; [ apply ERA_comp | ].
      apply ectx_rst_rel_comp_mctx; [ | assumption ].
      eapply ectx_rst_rel_monotone; [ | eassumption ].
      apply HRS.
    * eapply val_rel_monotone; [ | eassumption ].
      apply ERA_id.
  - intros F x v Heq; exfalso.
    rewrite <- ecomp_eplug in Heq.
    eapply open_is_stuck; rewrite <- Heq.
    apply red_shift.
+ intros E ? Heq; destruct E; discriminate.
Qed.

Lemma ectxrst_active_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxrst R ⊆ active_step (ectxrst_act S).
Proof.
intros HRS V t₁ t₂ Ht.
eapply active_step_monotone; [ apply ectxrst_act_repr | ].
eapply ectxrst_active_evolution'; eassumption.
Qed.

Lemma ectxrst_evolution : ectxrst ↝ ectxrst & ectxrst_act.
Proof.
intros R S HRS; split.
+ apply (ectxrst_passive_evolution _ _ HRS).
+ apply ectxrst_active_evolution; assumption.
Qed.