Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import Reduction LangProperties Monotonicity.
Require Import UpToMap UpToSubst CtxComp.

Inductive ectxr_act' (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
| EA_id    : R V t₁ t₂ →
    ectxr_act' R V t₁ t₂
| EA_ectxr : ectxr R V t₁ t₂ →
    ectxr_act' R V t₁ t₂
| EA_subst_act : subst_act R V t₁ t₂ →
    ectxr_act' R V t₁ t₂
| EA_ectx_comp : (id ∪ (ectxr ◦ map)) R V t₁ t₂ →
    ectxr_act' R V t₁ t₂
.

Definition ectxr_act : term_rel → term_rel :=
  (id ∪ (ectxr ◦ map)) ∪ subst_act.

Lemma ectxr_act_repr (R : term_rel) :
  ectxr_act' R ⊆ ectxr_act R.
Proof.
intros V t₁ t₂ H; destruct H; unfold ectxr_act.
+ left; left; auto.
+ left; right; eapply ectxr_monotone; [ | eassumption ].
  apply map_id_monotone; auto.
+ right; assumption.
+ left; auto.
Qed.

Lemma ectxr_passive_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxr R ⊆ passive_step ((ectxr ∪ (subst ◦ map)) R).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ left; constructor; assumption.
+ intros v₁ Heq; destruct E₁; try discriminate.
  simpl in Heq; subst.
  apply (progress_value HRS) in Ht; destruct Ht as [ v₂ [ Hred₁ Hv ] ].
  unfold ectx_rel in HE; simpl in HE.
  apply (progress_value HRS) in HE; destruct HE as [ u [ Hred₂ Hu ] ].
  apply red_rtc_subst with (v := v₂) in Hred₂.
  rewrite bind_eplug in Hred₂; simpl in Hred₂.
  rewrite subst_eshift in Hred₂.
  exists (u {v↦ v₂}); split.
  - eapply red_rtc_trans; [ | eassumption ].
    apply red_rtc_in_ectx; assumption.
  - apply val_rel_subst with (w₁ := v₁) (w₂ := v₂) in Hu; [ | assumption ].
    simpl in Hu.
    eapply val_rel_monotone; [ | eassumption ].
    unfold trf_sum; auto.
Qed.

Lemma ectxr_active_val_red (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (t₁' : term V) (v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rel R _ E₁ E₂ →
  R _ v₁ t₂ →
  red (E₁ $[ v₁ ]) t₁' →
  ∃ t₂' : term V, red_rtc (E₂ $[ t₂]) t₂' ∧ ectxr_act' S V t₁' t₂'.
Proof.
intros HRS HE Ht₂ Hred.
apply (progress_value HRS) in Ht₂.
destruct Ht₂ as [ v₂ [ Hred₂ Hv ] ].
unfold ectx_rel in HE.
apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
repeat rewrite bind_eplug in HE; simpl in HE.
repeat rewrite subst_eshift in HE.
assert (HRS' := HRS); apply subst_evolution in HRS'.
eapply (progress_step HRS') in HE; [ | eassumption ].
destruct HE as [ t₂' [ Hred₂' Ht' ] ].
exists t₂'; split.
+ eapply red_rtc_trans; [ | eassumption ].
  apply red_rtc_in_ectx; assumption.
+ apply EA_subst_act; assumption.
Qed.

Lemma ectxr_active_val_open (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (F₁ : mctx V) (x : V) (w₁ v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rel R _ E₁ E₂ →
  R _ v₁ t₂ →
  E₁ $[ v₁ ] = F₁ $$[ tm_app (val_var x) w₁ ] →
  ∃ (F₂ : mctx V) (w₂ : value V),
    red_rtc (E₂ $[ t₂]) (F₂ $$[ tm_app (val_var x) w₂ ]) 
    ∧ mctx_rel (ectxr_act' S) V F₁ F₂
    ∧ val_rel (ectxr_act' S) V w₁ w₂.
Proof.
intros HRS HE Ht₂ Heq.
apply (progress_value HRS) in Ht₂.
destruct Ht₂ as [ v₂ [ Hred Hv ] ].
unfold ectx_rel in HE.
apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
repeat rewrite bind_eplug in HE; simpl in HE.
repeat rewrite subst_eshift in HE.
assert (HRS' := HRS); apply subst_evolution in HRS'.
rewrite Heq in HE.
eapply (progress_open HRS') in HE.
destruct HE as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
exists F₂; exists w₂; split; [ | split ].
+ eapply red_rtc_trans; [ | eassumption ].
  apply red_rtc_in_ectx; assumption.
+ eapply mctx_rel_monotone; [ | eassumption ].
  apply EA_subst_act.
+ eapply val_rel_monotone; [ | eassumption ].
  apply EA_subst_act.
Qed.

Lemma ectxr_active_val_ctrl (R S : term_rel) {V : Set}
  (E₁ E₂ : ectx V) (E₁' : ectx V) (w₁ v₁ : value V) (t₂ : term V) :
  R ↣ R & S →
  ectx_rel R _ E₁ E₂ →
  R _ v₁ t₂ →
  E₁ $[ v₁ ] = E₁' $[ tm_app val_sft w₁ ] →
  ∃ (E₂' : ectx V) (w₂ : value V),
    red_rtc (E₂ $[ t₂]) (E₂' $[ tm_app val_sft w₂ ]) 
    ∧ ectx_rel (ectxr_act' S) V E₁' E₂'
    ∧ val_rel_rst (ectxr_act' S) V w₁ w₂.
Proof.
intros HRS HE Ht₂ Heq.
apply (progress_value HRS) in Ht₂.
destruct Ht₂ as [ v₂ [ Hred Hv ] ].
unfold ectx_rel in HE.
apply Mk_subst with (v₁ := v₁) (v₂ := v₂) in HE; [ | assumption ].
repeat rewrite bind_eplug in HE; simpl in HE.
repeat rewrite subst_eshift in HE.
assert (HRS' := HRS); apply subst_evolution in HRS'.
rewrite Heq in HE.
eapply (progress_ctrl HRS') in HE.
destruct HE as [ E₂' [ w₂ [ Hred₂ [ HE Hw ] ] ] ].
exists E₂'; exists w₂; split; [ | split ].
+ eapply red_rtc_trans; [ | eassumption ].
  apply red_rtc_in_ectx; assumption.
+ eapply ectx_rel_monotone; [ | eassumption ].
  apply EA_subst_act.
+ eapply val_rel_rst_monotone; [ | eassumption ].
  apply EA_subst_act.
Qed.

Lemma ectxr_active_evolution' (R S : term_rel) :
  R ↣ R & S →
  ectxr R ⊆ active_step (ectxr_act' S).
Proof.
intros HRS V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; split.
+ apply EA_ectxr; constructor.
  - eapply ectx_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
  - apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁' v₁ ].
  - intro; eapply ectxr_active_val_red; eassumption.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    intros r Hred'.
    eapply red_determ in Hred'; [ | apply red_in_ectx; eassumption ]; subst.
    exists (E₂ $[ t₂' ]); split.
    * apply red_rtc_in_ectx; assumption.
    * apply EA_ectxr; constructor; [ | assumption ].
      eapply ectx_rel_monotone; [ | eassumption ].
      apply (progress_sub_active HRS).
  - intros ? Hred; rewrite <- mplug_pure, <- mcomp_mplug in Hred.
    apply open_is_stuck in Hred; destruct Hred.
  - intros ? Hred; rewrite <- ecomp_eplug in Hred.
    apply ctrl_is_stuck in Hred; destruct Hred.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁' v₁ ].
  - intros ? ? ?; eapply ectxr_active_val_open; eassumption.
  - intros F₁ x v₁ Heq.
    apply red_in_ectx with (E := E₁) in Hred; rewrite Heq in Hred.
    apply open_is_stuck in Hred; destruct Hred.
  - eapply (progress_open HRS) in Ht.
    destruct Ht as [ F₂ [ v₂ [ Hred₂ [ HF Hv ] ] ] ].
    intros G₁ z w₂ Heq; symmetry in Heq.
    rewrite <- mplug_pure, <- mcomp_mplug in Heq.
    apply open_stuck_unique in Heq; destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (mcomp E₂ F₂); exists v₂; split; [ | split ].
    * rewrite mcomp_mplug, mplug_pure; apply red_rtc_in_ectx; assumption.
    * eapply mctx_rel_monotone; [ apply EA_ectx_comp | ].
      apply ectx_rel_comp_mctx; [ | assumption ].
      eapply ectx_rel_monotone; [ | eassumption ].
      apply HRS.
    * eapply val_rel_monotone; [ | eassumption ].
      apply EA_id.
  - intros F x v Heq; rewrite <- ecomp_eplug in Heq.
    apply ctrl_is_not_open in Heq; destruct Heq.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁' v₁ ].
  - intros ? ?; eapply ectxr_active_val_ctrl; eassumption.
  - intros E₁' v₁ Heq.
    apply red_in_ectx with (E := E₁) in Hred; rewrite Heq in Hred.
    apply ctrl_is_stuck in Hred; destruct Hred.
  - intros E₁' w₂ Heq; rewrite <- mplug_pure, <- mcomp_mplug in Heq.
    apply open_is_not_ctrl in Heq; destruct Heq.
  - intros E v Heq.
    rewrite <- ecomp_eplug in Heq; symmetry in Heq.
    apply ctrl_stuck_unique in Heq; destruct Heq; subst.
    apply (progress_ctrl HRS) in Ht.
    destruct Ht as [ E₂' [ v₂ [ Hred₂ [ HE' Hv ] ] ] ].
    exists (ecomp E₂ E₂'); exists v₂; split; [ | split ].
    * rewrite ecomp_eplug; apply red_rtc_in_ectx; assumption.
    * apply EA_ectx_comp; right; apply ectx_rel_comp; [ | assumption ].
      eapply ectx_rel_monotone; [ | eassumption ]; apply HRS.
    * apply EA_id; assumption.
Qed.

Lemma ectxr_active_evolution (R S : term_rel) :
  R ↣ R & S →
  ectxr R ⊆ active_step (ectxr_act S).
Proof.
intros HRS V t₁ t₂ Ht.
eapply active_step_monotone; [ apply ectxr_act_repr | ].
eapply ectxr_active_evolution'; eassumption.
Qed.

Lemma ectxr_evolution : ectxr ↝ (ectxr ∪ (subst ◦ map)) & ectxr_act.
Proof.
intros R S HRS; split.
+ apply (ectxr_passive_evolution _ _ HRS).
+ apply ectxr_active_evolution; assumption.
Qed.