Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques Monotonicity.
Require Import Reduction LangProperties.
Require Import UpToEctx.

Definition app_act : term_rel → term_rel :=
  (id ∪ (app ◦ map)) ∪ (subst ∪ ectxr_act).

Lemma app_passive_evolution (R : term_rel) :
  app R ⊆ passive_step (app R).
Proof.
intros V _ _ [ t₁ t₂ s₁ s₂ HR₁ HR₂ ]; split.
+ constructor; assumption.
+ intros ? ?; discriminate.
Qed.

Lemma mctx_rel_app1 (R : term_rel) {V : Set}
  (F₁ F₂ : mctx V) (t₁ t₂ : term V) :
  mctx_rel R _ F₁ F₂ →
  R _ t₁ t₂ →
  mctx_rel ((id ∪ (app ◦ map)) R) _ (mctx_app1 F₁ t₁) (mctx_app1 F₂ t₂).
Proof.
intros HF Ht.
destruct HF as [ E₁ E₂ HE | F₁ F₂ E₁ E₂ HE HF ].
+ change (mctx_rel ((id ∪ (app ◦ map)) R) V (ectx_app1 E₁ t₁) (ectx_app1 E₂ t₂)).
  constructor; unfold ectx_rel; simpl.
  right; constructor.
  - apply Mk_map_id; assumption.
  - constructor; assumption.
+ change (mctx_rel ((id ∪ (app ◦ map)) R) V
    (mcomp (mctx_app1 F₁ t₁) (mctx_rst E₁))
    (mcomp (mctx_app1 F₂ t₂) (mctx_rst E₂))); constructor.
  - left; assumption.
  - right; simpl; constructor.
    * apply Mk_map_id; assumption.
    * constructor; assumption.
Qed.

Lemma app_active_evolution (R S : term_rel) :
  R ↣ R & S → app R ⊆ active_step (app_act S).
Proof.
intros HRS V _ _ [ t₁ t₂ s₁ s₂ HR₁ HR₂ ]; split.
+ left; right; constructor; apply Mk_map_id;
    apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁ v₁ ].
  - destruct (progress_value HRS HR₁) as [ v₂ [ Hred_t Hv ] ].
    assert (HappV : ectxr R _ (tm_app v₁ s₁) (tm_app v₂ s₂)).
    { apply Mk_appV; assumption. }
    assert (HRS' := HRS); apply ectxr_evolution in HRS'.
    intros t₁' Hred; eapply (progress_step HRS') in HappV;
      [ | eassumption ].
    destruct HappV as [ t₂' [ Hred₂ Ht' ] ].
    exists t₂'; split.
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_app1; assumption.
    * unfold app_act, trf_sum; auto.
  - eapply (progress_step HRS) in HR₁; [ | eassumption ].
    destruct HR₁ as [ t₂' [ Hred₂ Ht' ] ].
    intros t₁'' Hred₁.
    eapply red_determ in Hred₁; [ | apply red_app1; eassumption ].
    subst.
    exists (tm_app t₂' s₂); split.
    * apply red_rtc_app1; assumption.
    * left; right; constructor; apply Mk_map_id; [ assumption | ].
      apply (progress_sub_active HRS); assumption.
  - intros ? Hred.
    exfalso; apply (open_is_stuck (mctx_app1 _ _)) in Hred; assumption.
  - intros ? Hred.
    exfalso; apply (ctrl_is_stuck (ectx_app1 _ _)) in Hred; assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' | F₁ x v₁ | E₁ v₁ ].
  - destruct (progress_value HRS HR₁) as [ v₂ [ Hred_t Hv ] ].
    assert (HappV : ectxr R _ (tm_app v₁ s₁) (tm_app v₂ s₂)).
    { apply Mk_appV; assumption. }
    assert (HRS' := HRS); apply ectxr_evolution in HRS'.
    intros F₁ x w₁ Heq; rewrite Heq in HappV.
    eapply (progress_open HRS') in HappV.
    destruct HappV as [ F₂ [ w₂ [ Hred₂ [ HF Hw ] ] ] ].
    exists F₂; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_app1; assumption.
    * eapply mctx_rel_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
    * eapply val_rel_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
  - intros F₁ x v₁ Heq; exfalso.
    eapply (open_is_stuck F₁ x v₁); rewrite <- Heq.
    apply red_app1; eassumption.
  - apply (progress_open HRS) in HR₁.
    destruct HR₁ as [ F₂ [ v₂ [ Hred₂ [ HF Hv ] ] ] ].
    intros F₁' z u₁ Heq; symmetry in Heq.
    apply (open_stuck_unique _ (mctx_app1 _ _)) in Heq.
    destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (mctx_app1 F₂ s₂); exists v₂; split; [ | split ].
    * simpl; apply red_rtc_app1; assumption.
    * { eapply mctx_rel_monotone; [ | apply mctx_rel_app1 ];
          [ | eassumption | ].
      + unfold app_act; apply sum_sub_l; auto.
      + apply (progress_sub_active HRS); assumption.
      }
    * left; left; assumption.
  - intros F₁ x w₁ Heq.
    change (ectx_app1 E₁ s₁ $[ tm_app val_sft v₁ ] =
        F₁ $$[ tm_app (val_var x) w₁ ]) in Heq.
    apply ctrl_is_not_open in Heq; destruct Heq.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | F₁ x v₁ | E₁ v₁ ].
  - destruct (progress_value HRS HR₁) as [ v₂ [ Hred_t Hv ] ].
    assert (HappV : ectxr R _ (tm_app v₁ s₁) (tm_app v₂ s₂)).
    { apply Mk_appV; assumption. }
    assert (HRS' := HRS); apply ectxr_evolution in HRS'.
    intros E₁ w₁ Heq; rewrite Heq in HappV.
    eapply (progress_ctrl HRS') in HappV.
    destruct HappV as [ E₂ [ w₂ [ Hred₂ [ HE Hw ] ] ] ].
    exists E₂; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_app1; assumption.
    * eapply ectx_rel_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
    * eapply val_rel_rst_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
  - intros E₁ v₁ Heq; exfalso.
    eapply (ctrl_is_stuck E₁ v₁); rewrite <- Heq.
    apply red_app1; eassumption.
  - intros E₁ w₁ Heq.
    change (mctx_app1 F₁ s₁ $$[ tm_app (val_var x) v₁ ] =
      E₁ $[ tm_app val_sft w₁ ]) in Heq.
    apply open_is_not_ctrl in Heq; destruct Heq.
  - intros E₁' v₁' Heq; symmetry in Heq.
    apply (progress_ctrl HRS) in HR₁.
    destruct HR₁ as [ E₂ [ v₂ [ Hred₂ [ HE Hv ] ] ] ].
    apply (ctrl_stuck_unique _ (ectx_app1 _ _)) in Heq.
    destruct Heq; subst.
    exists (ectx_app1 E₂ s₂); exists v₂; split; [ | split ].
    * simpl; apply red_rtc_app1; assumption.
    * left; right; simpl; constructor; [ apply Mk_map_id; assumption | ].
      constructor; apply (progress_sub_active HRS); assumption.
    * left; left; assumption.
Qed.

Lemma app_evolution : app ↝ app & app_act.
Proof.
intros R S HRS; split.
+ apply app_passive_evolution.
+ apply app_active_evolution; assumption.
Qed.