Require Import Utf8.
Require Import Lang TermRelation.

Definition ectx_rel (R : term_rel) (V : Set) (E₁ E₂ : ectx V) :=
  R _ (eshift E₁ $[ val_var VZ ]) (eshift E₂ $[ val_var VZ ]).
Definition val_rel (R : term_rel) (V : Set) (v₁ v₂ : value V) :=
  R _ (tm_app (vshift v₁) (val_var VZ)) (tm_app (vshift v₂) (val_var VZ)).
Definition val_rel_rst (R : term_rel) (V : Set) (v₁ v₂ : value V) :=
  R _ (tm_rst (tm_app (vshift v₁) (val_var VZ)))
      (tm_rst (tm_app (vshift v₂) (val_var VZ))).

Definition ectx_rst_rel (R : term_rel) (V : Set) (E₁ E₂ : ectx V) :=
  R _ (tm_rst (eshift E₁ $[ val_var VZ ]))
      (tm_rst (eshift E₂ $[ val_var VZ ])).
Definition mctx_val_rel (R : term_rel) (V : Set) (F₁ F₂ : mctx V) :=
  R _ (mshift F₁ $$[ val_var VZ ]) (mshift F₂ $$[ val_var VZ ]).

Inductive mctx_rel (R : term_rel) (V : Set) : mctx V → mctx V → Prop :=
| mctx_rel_pure : ∀ E₁ E₂ : ectx V,
    ectx_rel R V E₁ E₂ →
    mctx_rel R V E₁ E₂
| mctx_rel_reset : ∀ (F₁ F₂ : mctx V) (E₁ E₂ : ectx V),
    ectx_rst_rel R _ E₁ E₂ →
    mctx_val_rel R _ F₁ F₂ →
    mctx_rel R V (mcomp F₁ (mctx_rst E₁)) (mcomp F₂ (mctx_rst E₂))
.

Record active_step (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
  { act_sub : R V t₁ t₂
  ; act_tau : ∀ t₁' : term V, red t₁ t₁' →
              ∃ t₂' : term V, red_rtc t₂ t₂' ∧ R _ t₁' t₂'
  ; act_opn : ∀ F₁ x (v₁ : value V), t₁ = F₁ $$[ tm_app (val_var x) v₁ ] →
              ∃ F₂ (v₂ : value V), red_rtc t₂ (F₂ $$[ tm_app (val_var x) v₂ ])
                  ∧ mctx_rel R _ F₁ F₂ ∧ val_rel R _ v₁ v₂
  ; act_ctl : ∀ E₁ (v₁ : value V), t₁ = E₁ $[ tm_app val_sft v₁ ] →
              ∃ E₂ (v₂ : value V), red_rtc t₂ (E₂ $[ tm_app val_sft v₂ ])
                  ∧ ectx_rel R _ E₁ E₂ ∧ val_rel_rst R _ v₁ v₂
  }.

Record passive_step (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
  { pas_sub : R V t₁ t₂
  ; pas_val : ∀ (v₁ : value V), t₁ = v₁ →
              ∃ (v₂ : value V), red_rtc t₂ v₂ ∧ val_rel R _ v₁ v₂
  }.

Record progress_towards (R Q S : term_rel) : Prop :=
  { pt_passive  : R ⊆ passive_step Q
  ; pt_active   : R ⊆ active_step S
  }.

Notation "R ↣ Q & S" := (progress_towards R Q S) (at level 70).

Definition evolves (f g h : term_rel → term_rel) :=
  ∀ R S, (R ↣ R & S) → (f R ↣ g R & h S).
Definition strongly_evolves (f g h : term_rel → term_rel) :=
  ∀ R Q S, (R ↣ Q & S) → (f R ↣ g Q & h S).

Notation "f ↝ g & h" := (evolves f g h) (at level 70).
Notation "f !↝ g & h" := (strongly_evolves f g h) (at level 70).

Lemma progress_sub_passive {R Q S : term_rel} (Hp : R ↣ Q & S) :
  R ⊆ Q.
Proof.
destruct Hp as [ Hp _ ].
intros V t₁ t₂ HR; specialize (Hp V t₁ t₂ HR).
apply Hp.
Qed.

Lemma progress_sub_active {R Q S : term_rel} (Hp : R ↣ Q & S) :
  R ⊆ S.
Proof.
destruct Hp as [ _ Hp ].
intros V t₁ t₂ HR; specialize (Hp V t₁ t₂ HR).
apply Hp.
Qed.

Lemma progress_value {R Q S : term_rel} (Hp : R ↣ Q & S)
  {V : Set} {v : value V} {t : term V} :
  R V v t →
  ∃ v' : value V, red_rtc t v' ∧ val_rel Q _ v v'.
Proof.
intro HR; destruct Hp as [ Hp _ ].
apply Hp in HR; destruct HR as [ _ Hv ].
apply Hv; reflexivity.
Qed.

Lemma progress_step {R Q S : term_rel} (Hp : R ↣ Q & S)
  {V : Set} {t₁ t₂ t₁' : term V} :
  R V t₁ t₂ → red t₁ t₁' →
  ∃ t₂' : term V, red_rtc t₂ t₂' ∧ S _ t₁' t₂'.
Proof.
intros HR Hred; destruct Hp as [ _ Hp ].
specialize (Hp V t₁ t₂ HR).
destruct Hp as [ _ Hp _ ].
exact (Hp t₁' Hred).
Qed.

Lemma progress_open {R Q S : term_rel} (Hp : R ↣ Q & S)
  {V : Set} (F₁ : mctx V) (x : V) (v₁ : value V) (t : term V) :
  R _ (F₁ $$[ tm_app (val_var x) v₁ ]) t →
  ∃ (F₂ : mctx V) (v₂ : value V), red_rtc t (F₂ $$[ tm_app (val_var x) v₂ ])
    ∧ mctx_rel S _ F₁ F₂ ∧ val_rel S _ v₁ v₂.
Proof.
intros HR; destruct Hp as [ _ Hp ].
specialize (Hp V (F₁ $$[ tm_app (val_var x) v₁ ]) t HR).
destruct Hp as [ _ _ Hp _ ].
exact (Hp _ _ _ eq_refl).
Qed.

Lemma progress_ctrl {R Q S : term_rel} (Hp : R ↣ Q & S)
  {V : Set} (E₁ : ectx V) (v₁ : value V) t₂ :
  R _ (E₁ $[ tm_app val_sft v₁ ]) t₂ →
  ∃ (E₂ : ectx V) (v₂ : value V), red_rtc t₂ (E₂ $[ tm_app val_sft v₂ ])
    ∧ ectx_rel S _ E₁ E₂ ∧ val_rel_rst S _ v₁ v₂.
Proof.
intros HR; destruct Hp as [ _ Hp ].
specialize (Hp V (E₁ $[ tm_app val_sft v₁ ]) t₂ HR).
destruct Hp as [ _ _ _ Hp ].
exact (Hp _ _ eq_refl).
Qed.

Lemma id_evolution : id !↝ id & id.
Proof.
intros R Q S; auto.
Qed.