Require Import Utf8.
Require Import Lang LangProperties.

Inductive class {V : Set} : term V → Set :=
| cl_value : ∀ v : value V, class v
| cl_red   : ∀ t t' : term V, red t t' → class t
| cl_open  : ∀ (F : mctx V) (x : V) (v : value V),
    class (F $$[ tm_app (val_var x) v ])
| cl_ctrl  : ∀ (E : ectx V) (v : value V),
    class (E $[ tm_app val_sft v ])
.

Fixpoint classify {V : Set} (t : term V) : class t.
Proof.
destruct t as [ v | t s | t ].
+ apply cl_value.
+ destruct (classify _ t) as [ v | t t' | F x v | E t ].
  - destruct (classify _ s) as [ w | s s' | F x w | E t ].
    * { destruct v as [ x | t | ].
      + apply (cl_open mctx_mt).
      + eapply cl_red; apply red_beta.
      + apply (cl_ctrl ectx_mt).
      }
    * eapply cl_red; apply red_app2; eassumption.
    * apply (cl_open (mctx_app2 _ F)).
    * apply (cl_ctrl (ectx_app2 _ E)).
  - eapply cl_red; apply red_app1; eassumption.
  - apply (cl_open (mctx_app1 F _)).
  - apply (cl_ctrl (ectx_app1 E _)).
+ destruct (classify _ t) as [ v | t t' | F x v | E t ].
  - eapply cl_red; apply red_reset.
  - eapply cl_red; apply red_rst; eassumption.
  - apply (cl_open (mctx_rst F)).
  - eapply cl_red; apply red_shift.
Defined.

Lemma red_in_ectx {V : Set} (E : ectx V) (t t' : term V) :
  red t t' → red (E $[ t ]) (E $[ t' ]).
Proof.
intro Hred; induction E as [ | E IHE s | v E IHE ]; simpl.
+ assumption.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
Qed.

Lemma red_in_mctx {V : Set} (F : mctx V) (t t' : term V) :
  red t t' → red (F $$[ t ]) (F $$[ t' ]).
Proof.
intro Hred; induction F as [ | F IHF s | v F IHF | F ]; simpl.
+ assumption.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
+ apply red_rst; assumption.
Qed.

Lemma red_rtc_in_ectx {V : Set} (E : ectx V) (t t' : term V) :
  red_rtc t t' → red_rtc (E $[ t ]) (E $[ t' ]).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_in_ectx; eassumption.
+ assumption.
Qed.

Lemma red_rtc_in_mctx {V : Set} (F : mctx V) (t t' : term V) :
  red_rtc t t' → red_rtc (F $$[ t ]) (F $$[ t' ]).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_in_mctx; eassumption.
+ assumption.
Qed.

Lemma open_is_not_ctrl {V : Set} (F : mctx V) (x : V) (v v' : value V)
  (E : ectx V) :
  F $$[ tm_app (val_var x) v ] = E $[ tm_app val_sft v' ] → False.
Proof.
generalize E; clear E.
induction F as [ | F IHF s | w F IHF | F IHF ].
+ intros [ | E s' | w' E ]; simpl; intro H; try discriminate.
  - injection H; clear H; intros; destruct E; discriminate.
  - injection H; clear H; intros; destruct E; discriminate.
+ intros [ | E s' | w' E ]; simpl; intro H; try discriminate.
  - destruct F; discriminate.
  - injection H; clear H; intros Heq₁ Heq₂.
    apply IHF in Heq₂; assumption.
  - destruct F; discriminate.
+ intros [ | E s' | w' E ]; simpl; intro H; try discriminate.
  - destruct F; discriminate.
  - destruct E; discriminate.
  - injection H; clear H; intros Heq₁ Heq₂.
    apply IHF in Heq₁; assumption.
+ intros [ | E s' | w' E ]; simpl; intro H; discriminate.
Qed.

Lemma ctrl_is_not_open {V : Set} (F : mctx V) (x : V) (v v' : value V)
  (E : ectx V) :
  E $[ tm_app val_sft v' ] = F $$[ tm_app (val_var x) v ] → False.
Proof.
intro H; eapply open_is_not_ctrl; symmetry; eassumption.
Qed.

Lemma open_is_stuck {V : Set} (F : mctx V) (x : V) (v : value V) t :
  red (F $$[ tm_app (val_var x) v ]) t → False.
Proof.
generalize t; clear t.
induction F as [ | F IHF s | w F IHF | F IHF ]; intro t; simpl.
+ intro H; inversion H; subst; clear H;
  match goal with [ H : red _ _ |- _ ] => inversion H end.
+ intro H; inversion H; subst; clear H;
    try (destruct F; discriminate; fail).
  eapply IHF; eassumption.
+ intro H; inversion H; subst; clear H.
  - destruct F; discriminate.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
  - eapply IHF; eassumption.
+ intro H; inversion H; subst; clear H.
  - eapply ctrl_is_not_open; eassumption.
  - destruct F; discriminate.
  - eapply IHF; eassumption.
Qed.

Lemma ctrl_is_stuck {V : Set} (E : ectx V) (v : value V) t' :
  red (E $[ tm_app val_sft v ]) t' → False.
Proof.
generalize t'; clear t'.
induction E as [ | E IHE s | w E IHE ]; intro t'; simpl.
+ intro H; inversion H; subst; clear H.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
+ intro H; inversion H; subst; clear H.
  - destruct E; discriminate.
  - eapply IHE; eassumption.
  - destruct E; discriminate.
+ intro H; inversion H; subst; clear H.
  - destruct E; discriminate.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
  - eapply IHE; eassumption.
Qed.

Lemma open_stuck_unique {V : Set}
  (F₁ F₂ : mctx V) (x₁ x₂ : V) (v₁ v₂ : value V) :
  F₁ $$[ tm_app (val_var x₁) v₁ ] = F₂ $$[ tm_app (val_var x₂) v₂ ] →
  F₁ = F₂ ∧ x₁ = x₂ ∧ v₁ = v₂.
Proof.
generalize F₂; clear F₂; induction F₁ as [ | F₁ IHF t₁ | w₁ F₁ IHF | F₁ IHF ];
  simpl; intros F₂ Heq.
+ destruct F₂ as [ | F₂ ? | ? F₂ | F₂ ]; simpl in Heq.
  - injection Heq; clear Heq; auto.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₂; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₂; discriminate.
  - discriminate.
+ destruct F₂ as [ | F₂ ? | ? F₂ | F₂ ]; simpl in Heq.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₁; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHF in Heq₂.
    repeat match goal with [ H : _ ∧ _ |- _ ] => destruct H end.
    subst; auto.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₁; discriminate.
  - discriminate.
+ destruct F₂ as [ | F₂ ? | ? F₂ | F₂ ]; simpl in Heq.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₁; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct F₂; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHF in Heq₁.
    repeat match goal with [ H : _ ∧ _ |- _ ] => destruct H end.
    subst; auto.
  - discriminate.
+ destruct F₂ as [ | F₂ ? | ? F₂ | F₂ ]; simpl in Heq.
  - discriminate.
  - discriminate.
  - discriminate.
  - injection Heq; clear Heq; intro Heq.
    apply IHF in Heq.
    repeat match goal with [ H : _ ∧ _ |- _ ] => destruct H end.
    subst; auto.
Qed.

Lemma ctrl_stuck_unique {V : Set}
  (E₁ E₂ : ectx V) (v₁ v₂ : value V) :
  E₁ $[ tm_app val_sft v₁ ] = E₂ $[ tm_app val_sft v₂ ] → E₁ = E₂ ∧ v₁ = v₂.
Proof.
generalize E₂; clear E₂; induction E₁ as [ | E₁ IHE s₁ | w₁ E₁ IHE ];
  simpl; intros E₂ Heq.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - injection Heq; auto.
  - destruct E₂; discriminate.
  - destruct E₂; discriminate.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - destruct E₁; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHE in Heq₂; destruct Heq₂; subst; auto.
  - destruct E₁; discriminate.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - destruct E₁; discriminate.
  - destruct E₂; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHE in Heq₁; destruct Heq₁; subst; auto.
Qed.

Lemma red_rtc_trans {V : Set} (t₁ t₂ t₃ : term V) :
  red_rtc t₁ t₂ → red_rtc t₂ t₃ → red_rtc t₁ t₃.
Proof.
induction 1 as [ | t₁ t₁' t₂ Hred Hrtc1 IH ]; [ auto | ].
intro Hrtc2; econstructor; eauto.
Qed.

Lemma red_rtc_app1 {V : Set} (t t' s : term V) :
  red_rtc t t' → red_rtc (tm_app t s) (tm_app t' s).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_app1; eassumption.
+ assumption.
Qed.

Lemma red_rtc_app2 {V : Set} (v : value V) (t t' : term V) :
  red_rtc t t' → red_rtc (tm_app v t) (tm_app v t').
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_app2; eassumption.
+ assumption.
Qed.

Lemma red_rtc_rst {V : Set} (t t' : term V) :
  red_rtc t t' → red_rtc (tm_rst t) (tm_rst t').
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_rst; eassumption.
+ assumption.
Qed.

Lemma red_beta' {V : Set} (t : term (inc V)) (v : value V) (t' : term V) :
  t {t↦ v} = t' → red (tm_app (val_lam t) v) t'.
Proof.
intro H; rewrite <- H; constructor.
Qed.

Lemma red_map {A B : Set} (t t' : term A) (f : A → B) :
  red t t' → red (tmap f t) (tmap f t').
Proof.
induction 1 as [ t w | t E | v | t t' s | w t t' | t t' ]; simpl.
+ apply red_beta', tmonad_bind_map.
  intros [ | x ]; reflexivity.
+ rewrite map_eplug, map_eplug; simpl.
  rewrite emonad_map_map'; simpl.
  rewrite <- (emonad_map_map' _ f (@VS _)).
  apply red_shift.
+ apply red_reset.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
+ apply red_rst; assumption.
Qed.

Lemma red_rtc_map {A B : Set} (t t' : term A) (f : A → B) :
  red_rtc t t' → red_rtc (tmap f t) (tmap f t').
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_map; eassumption.
+ assumption.
Qed.

Lemma red_subst {V : Set} (t t' : term (inc V)) (v : value V) :
  red t t' → red (t {t↦ v}) (t' {t↦ v}).
Proof.
induction 1 as [ t w | t E | w | t t' s | w t t' | t t' ]; simpl.
+ apply red_beta', tmonad_bind_bind.
  intros [ | [ | x ] ]; simpl; try reflexivity.
  apply subst_vshift.
+ rewrite bind_eplug, bind_eplug; simpl.
  erewrite emonad_bind_map; [ apply red_shift | ].
  intros [ | x ]; reflexivity.
+ apply red_reset.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
+ apply red_rst; assumption.
Qed.

Lemma red_rtc_subst {V : Set} (t t' : term (inc V)) (v : value V) :
  red_rtc t t' → red_rtc (t {t↦ v}) (t' {t↦ v}).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_subst; eassumption.
+ assumption.
Qed.

Lemma red_determ {V : Set} (t t₁ t₂ : term V) :
  red t t₁ → red t t₂ → t₁ = t₂.
Proof.
intro Hred; generalize t₂; clear t₂.
induction Hred as [ | ? E | | | | ]; intros t₂ Hred2.
+ inversion Hred2; try reflexivity;
  match goal with [ H : red (tm_val _) _ |- _ ] => inversion H end.
+ inversion Hred2; subst.
  - match goal with
    [ H : _ $[ _ ] = _ $[ _ ] |- _ ] =>
        apply ctrl_stuck_unique in H; destruct H; subst; reflexivity
    end.
  - destruct E; discriminate.
  - exfalso; eapply ctrl_is_stuck; eassumption.
+ inversion Hred2 as [ | ? E | | | | ]; clear Hred2.
  - destruct E; discriminate.
  - reflexivity.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
+ inversion Hred2; subst;
    try match goal with
    [ H : red (tm_val _) _ |- _ ] => inversion H; fail
    end.
  erewrite IHHred; [ reflexivity | eassumption ].
+ inversion Hred2; subst;
    try match goal with
    [ H : red (tm_val _) _ |- _ ] => inversion H; fail
    end.
  erewrite IHHred; [ reflexivity | eassumption ].
+ inversion Hred2; subst; clear Hred2.
  - exfalso; eapply ctrl_is_stuck; eassumption.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
  - erewrite IHHred; [ reflexivity | eassumption ].
Qed.

Lemma red_app2_determ {V : Set} (v : value V) (t₁ t₂ t : term V) :
  red t₁ t₂ → red (tm_app v t₁) t → t = tm_app v t₂.
Proof.
intros Hred1 Hred2.
inversion Hred2; subst.
+ inversion Hred1.
+ match goal with [ H : red (tm_val _) _ |- _ ] => inversion H end.
+ erewrite (red_determ _ _ _ Hred1); [ reflexivity | ]; assumption.
Qed.

Lemma red_mplug_appv {V : Set} (F : mctx V) (v w : value V) (r : term V) :
  red (F $$[ tm_app v w ]) r →
  (∃ t, v = val_lam t ∧ r = F $$[ t {t↦ w } ]) ∨
  (∃ (F' : mctx V) (E : ectx V), F = mcomp F' (mctx_rst E)
    ∧ v = val_sft
    ∧ r = F' $$[
        tm_rst (tm_app w (val_lam (tm_rst (eshift E $[ val_var VZ ])))) ]).
Proof.
intro Hred.
destruct v as [ x | t | ].
+ apply open_is_stuck in Hred; destruct Hred.
+ left; exists t; split; [ reflexivity | ].
  eapply red_determ; [ eassumption | ].
  apply red_in_mctx; constructor.
+ destruct (mctx_case F) as [ [ E H ] | [ F' [ E H ] ] ]; subst.
  - rewrite mplug_pure in Hred; apply ctrl_is_stuck in Hred; destruct Hred.
  - right; exists F'; exists E; repeat constructor.
    eapply red_determ; [ eassumption | ].
    rewrite mcomp_mplug; simpl.
    apply red_in_mctx; rewrite mplug_pure; apply red_shift.
Qed.

Lemma red_mplug_rst {V : Set} (F : mctx V) (t t' : term V) :
  red (F $$[ tm_rst t ]) t' →
  ∃ r, red (tm_rst t) r ∧ pure_term r ∧ t' = F $$[ r ].
Proof.
intro Hred; destruct (classify t) as [ v | t s | F' x v | E v ].
+ exists v; split; [ | split ].
  - apply red_reset.
  - constructor.
  - eapply red_determ; [ eassumption | ].
    apply red_in_mctx; constructor.
+ exists (tm_rst s); split; [ | split ].
  - apply red_rst; assumption.
  - constructor.
  - eapply red_determ; [ eassumption | ].
    apply red_in_mctx; constructor; assumption.
+ exfalso.
  change (red (F $$[ mctx_rst F' $$[ tm_app (val_var x) v ] ]) t') in Hred.
  rewrite <- mcomp_mplug in Hred; apply open_is_stuck in Hred; assumption.
+ eexists; split; [ | split ].
  - apply red_shift.
  - constructor.
  - eapply red_determ; [ eassumption | ].
    apply red_in_mctx; constructor.
Qed.

Lemma open_mplug_rst {V : Set}
  (F F' : mctx V) (t : term V) (x : V) (v : value V) :
  F $$[ tm_rst t ] = F' $$[ tm_app (val_var x) v ] →
  ∃ G : mctx V, F' = mcomp F (mctx_rst G) ∧ t = G $$[ tm_app (val_var x) v ].
Proof.
generalize F'; clear F'.
induction F as [ | F IHF s | w F IHF | F IHF ]; simpl;
  intros F' Heq; destruct F' as [ | F' s' | w' F' | F' ]; try discriminate;
  simpl in Heq.
+ exists F'; split; [ reflexivity | ].
  injection Heq; auto.
+ destruct F; discriminate.
+ injection Heq; clear Heq; intros H Heq; rewrite_all H; clear H.
  apply IHF in Heq; destruct Heq as [ G [ HF Ht ] ]; subst.
  exists G; split; reflexivity.
+ destruct F; discriminate.
+ destruct F; discriminate.
+ destruct F'; discriminate.
+ injection Heq; clear Heq; intros Heq H; rewrite_all H; clear H.
  apply IHF in Heq; destruct Heq as [ G [ HF Ht ] ]; subst.
  exists G; split; reflexivity.
+ injection Heq; clear Heq; intro Heq.
  apply IHF in Heq; destruct Heq as [ G [ HF Ht ] ]; subst.
  exists G; split; reflexivity.
Qed.

Lemma ctrl_not_mplug_rst {V : Set}
  (F : mctx V) (t : term V) (E : ectx V) (v : value V) :
  F $$[ tm_rst t ] = E $[ tm_app val_sft v ] → False.
Proof.
generalize F; clear F.
induction E as [ | E IHE s | w E IHE ]; simpl;
  intros F Heq; destruct F as [ | F s' | w' F | F ]; try discriminate;
  simpl in Heq.
+ destruct F; discriminate.
+ destruct F; discriminate.
+ injection Heq; clear Heq; intros _ Heq.
  eapply IHE; eassumption.
+ destruct E; discriminate.
+ destruct F; discriminate.
+ injection Heq; clear Heq; intros Heq _.
  eapply IHE; eassumption.
Qed.

Lemma red_pure {V : Set} (t t' : term V) :
  pure_term t → red t t' → pure_term t'.
Proof.
intros Hpure Hred; inversion Hpure; subst;
  inversion Hred; subst; constructor.
Qed.

Lemma red_rtc_pure {V : Set} (t t' : term V) :
  pure_term t → red_rtc t t' → pure_term t'.
Proof.
intros H Hred; generalize H; clear H.
induction Hred as [ | ? ? ? Hred ]; [ auto | ].
intro; apply red_pure in Hred; auto.
Qed.