Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.

Lemma val_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (v₁ v₂ : value V),
  val_rel R _ v₁ v₂ → val_rel S _ v₁ v₂.
Proof.
intros HRS V v₁ v₂; unfold val_rel; apply HRS.
Qed.

Lemma val_rel_rst_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (v₁ v₂ : value V),
  val_rel_rst R _ v₁ v₂ → val_rel_rst S _ v₁ v₂.
Proof.
intros HRS V v₁ v₂; unfold val_rel_rst; apply HRS.
Qed.

Lemma ectx_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (E₁ E₂ : ectx V),
  ectx_rel R _ E₁ E₂ → ectx_rel S _ E₁ E₂.
Proof.
intros HRS V E₁ E₂; unfold ectx_rel; apply HRS.
Qed.

Lemma ectx_rst_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (E₁ E₂ : ectx V),
  ectx_rst_rel R _ E₁ E₂ → ectx_rst_rel S _ E₁ E₂.
Proof.
intros HRS V E₁ E₂; unfold ectx_rst_rel; apply HRS.
Qed.

Lemma mctx_val_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (F₁ F₂ : mctx V),
  mctx_val_rel R _ F₁ F₂ → mctx_val_rel S _ F₁ F₂.
Proof.
intros HRS V F₁ F₂; unfold mctx_val_rel; apply HRS.
Qed.

Lemma mctx_rel_monotone {R S : term_rel} :
  R ⊆ S → ∀ (V : Set) (F₁ F₂ : mctx V),
  mctx_rel R _ F₁ F₂ → mctx_rel S _ F₁ F₂.
Proof.
intros HRS V _ _ [ E₁ E₂ HE | F₁ F₂ E₁ E₂ HE HF ].
+ apply mctx_rel_pure; eapply ectx_rel_monotone; eassumption.
+ apply mctx_rel_reset; apply HRS; assumption.
Qed.

Lemma passive_step_monotone : monotone passive_step.
Proof.
intros R S HRS V t₁ t₂ Hpas; split.
+ apply HRS, Hpas.
+ intros v Heq; apply Hpas in Heq; destruct Heq as [v₂ [ Hred Hv ] ].
  exists v₂; firstorder.
Qed.

Lemma active_step_monotone : monotone active_step.
Proof.
intros R S HRS V t₁ t₂ Hact; split.
+ apply HRS, Hact.
+ intros t₁' Hred; apply Hact in Hred; destruct Hred as [ t₂' [ Hred' Ht' ] ].
  exists t₂'; firstorder.
+ intros F₁ x v₁ Heq.
  apply Hact in Heq; destruct Heq as [ F₂ [ v₂ [ Hred [ HF Hv ] ] ] ].
  exists F₂; exists v₂.
  split; [ apply Hred | ].
  split; [ eapply mctx_rel_monotone | eapply val_rel_monotone ]; eassumption.
+ intros E₁ t₁' Heq.
  apply Hact in Heq; destruct Heq as [ E₂ [ t₂' [ Hred [ HE Ht ] ] ] ].
  exists E₂; exists t₂'; firstorder.
Qed.

Lemma var_monotone : monotone var.
Proof.
intros R S Hsub V _ _ [ x ]; constructor.
Qed.

Lemma var2_monotone : monotone var2.
Proof.
intros R S Hsub V _ _ []; intros; constructor.
Qed.

Lemma lam_monotone : monotone lam.
Proof.
intros R S Hsub V _ _ []; intros; constructor; apply Hsub; assumption.
Qed.

Lemma sft_monotone : monotone sft.
Proof.
intros R S Hsub V _ _ []; constructor.
Qed.

Lemma sft2_monotone : monotone sft2.
Proof.
intros R S Hsub V _ _ [ x ]; constructor.
Qed.

Lemma app_monotone : monotone app.
Proof.
intros R S Hsub V _ _ [ t₁ t₂ s₁ s₂ Ht Hs ]; constructor;
  apply Hsub; assumption.
Qed.

Lemma subst_monotone : monotone subst.
Proof.
intros R S Hsub V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; constructor.
+ apply Hsub; assumption.
+ apply (val_rel_monotone Hsub); assumption.
Qed.

Lemma ectxr_monotone : monotone ectxr.
Proof.
intros R S Hsub V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; constructor.
+ apply (ectx_rel_monotone Hsub); assumption.
+ apply Hsub; assumption.
Qed.

Lemma ectxrst_monotone : monotone ectxrst.
Proof.
intros R S Hsub V _ _ [ E₁ E₂ t₁ t₂ HE Ht ]; constructor.
+ apply (ectx_rst_rel_monotone Hsub); assumption.
+ apply Hsub; assumption.
Qed.

Lemma mctxvpure_monotone : monotone mctxvpure.
Proof.
intros R S Hsub V _ _ [ F₁ F₂ t₁ t₂ Hf Ht ]; constructor.
+ assumption.
+ assumption.
+ apply (mctx_val_rel_monotone Hsub); assumption.
+ apply Hsub; assumption.
Qed.

Lemma map_monotone : monotone map.
Proof.
intros R S Hsub V _ _ [ W t₁ t₂ Ht ];
constructor; apply Hsub; assumption.
Qed.

Lemma redr_monotone : monotone redr.
Proof.
intros R S Hsub V t₁ t₂ []; intros; econstructor; try eassumption.
apply Hsub; assumption.
Qed.

Lemma map_id_monotone {R S : term_rel} :
  R ⊆ S → R ⊆ map S.
Proof.
intros HRS V t₁ t₂ Ht; apply Mk_map_id; auto.
Qed.

Lemma redr_id_monotone {R S : term_rel} :
  R ⊆ S → R ⊆ redr S.
Proof.
intros HRS V t₁ t₂ Ht; apply Mk_redr_id; auto.
Qed.