Require Import Utf8.
Require Import Lang.

Fixpoint tmonad_map_id {A : Set} (t : term A) :
  ∀ (f : A → A), (∀ x, f x = x) → tmap f t = t
with vmonad_map_id {A : Set} (v : value A) :
  ∀ (f : A → A), (∀ x, f x = x) → vmap f v = v.
Proof.
+ intros f Hf; destruct t as [ v | t s | t ]; simpl.
  - rewrite vmonad_map_id; [ reflexivity | assumption ].
  - rewrite tmonad_map_id; [ | assumption ].
    rewrite tmonad_map_id; [ | assumption ].
    reflexivity.
  - rewrite tmonad_map_id; [ reflexivity | assumption ].
+ intros f Hf; destruct v as [ x | t | ]; simpl.
  - rewrite Hf; reflexivity.
  - rewrite tmonad_map_id; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hf; reflexivity.
  - reflexivity.
Qed.

Lemma emonad_map_id {A : Set} (E : ectx A) :
  ∀ (f : A → A), (∀ x, f x = x) → emap f E = E.
Proof.
intros f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE, tmonad_map_id; auto.
+ rewrite IHE, vmonad_map_id; auto.
Qed.

Lemma mmonad_map_id {A : Set} (F : mctx A) :
  ∀ (f : A → A), (∀ x, f x = x) → mmap f F = F.
Proof.
intros f Hf; induction F as [ | F IHF t | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF, tmonad_map_id; auto.
+ rewrite IHF, vmonad_map_id; auto.
+ rewrite IHF; auto.
Qed.

Lemma tmonad_map_id' {A : Set} (t : term A) :
  tmap (λ x, x) t = t.
Proof.
apply tmonad_map_id; reflexivity.
Qed.

Lemma vmonad_map_id' {A : Set} (v : value A) :
  vmap (λ x, x) v = v.
Proof.
apply vmonad_map_id; reflexivity.
Qed.

Lemma emonad_map_id' {A : Set} (E : ectx A) :
  emap (λ x, x) E = E.
Proof.
apply emonad_map_id; reflexivity.
Qed.

Lemma mmonad_map_id' {A : Set} (F : mctx A) :
  mmap (λ x, x) F = F.
Proof.
apply mmonad_map_id; reflexivity.
Qed.

Fixpoint tmonad_map_map {A B C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  tmap f₂ (tmap f₁ t) = tmap f t
with vmonad_map_map {A B C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  vmap f₂ (vmap f₁ v) = vmap f v.
Proof.
+ intros f₁ f₂ f Hf; destruct t as [ v | t s | t ]; simpl.
  - erewrite vmonad_map_map; [ reflexivity | eassumption ].
  - erewrite tmonad_map_map; [ | eassumption ].
    erewrite tmonad_map_map; [ | eassumption ].
    reflexivity.
  - erewrite tmonad_map_map; [ reflexivity | assumption ].
+ intros f₁ f₂ f Hf; destruct v as [ x | t | ]; simpl.
  - rewrite Hf; reflexivity.
  - erewrite tmonad_map_map; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hf; reflexivity.
  - reflexivity.
Qed.

Lemma emonad_map_map {A B C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  emap f₂ (emap f₁ E) = emap f E.
Proof.
intros f₁ f₂ f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ erewrite IHE, tmonad_map_map; [ reflexivity | eassumption ].
+ erewrite IHE, vmonad_map_map; [ reflexivity | eassumption ].
Qed.

Lemma mmonad_map_map {A B C : Set} (F : mctx A) :
  ∀ (f₁ : A → B) (f₂ : B → C) (f : A → C),
  (∀ x, f₂ (f₁ x) = f x) →
  mmap f₂ (mmap f₁ F) = mmap f F.
Proof.
intros f₁ f₂ f Hf; induction F as [ | F IHF t | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ erewrite IHF, tmonad_map_map; [ reflexivity | eassumption ].
+ erewrite IHF, vmonad_map_map; [ reflexivity | eassumption ].
+ erewrite IHF; reflexivity.
Qed.

Lemma tmonad_map_map' {A B C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  tmap f₂ (tmap f₁ t) = tmap (λ x, f₂ (f₁ x)) t.
Proof.
intros; apply tmonad_map_map; reflexivity.
Qed.

Lemma vmonad_map_map' {A B C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  vmap f₂ (vmap f₁ v) = vmap (λ x, f₂ (f₁ x)) v.
Proof.
intros; apply vmonad_map_map; reflexivity.
Qed.

Lemma emonad_map_map' {A B C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  emap f₂ (emap f₁ E) = emap (λ x, f₂ (f₁ x)) E.
Proof.
intros; apply emonad_map_map; reflexivity.
Qed.

Lemma mmonad_map_map' {A B C : Set} (F : mctx A) :
  ∀ (f₁ : A → B) (f₂ : B → C),
  mmap f₂ (mmap f₁ F) = mmap (λ x, f₂ (f₁ x)) F.
Proof.
intros; apply mmonad_map_map; reflexivity.
Qed.

Fixpoint tmonad_bind_map {A B B' C : Set} (t : term A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  tbind f₂ (tmap f₁ t) = tmap g₂ (tbind g₁ t)
with vmonad_bind_map {A B B' C : Set} (v : value A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  vbind f₂ (vmap f₁ v) = vmap g₂ (vbind g₁ v).
Proof.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct t as [ v | t s | t ]; simpl.
  - erewrite vmonad_bind_map; [ | eassumption ]; reflexivity.
  - erewrite tmonad_bind_map; [ | eassumption ].
    erewrite tmonad_bind_map; [ | eassumption ].
    reflexivity.
  - erewrite tmonad_bind_map; [ reflexivity | assumption ].
+ intros f₁ f₂ g₁ g₂ Hfg; destruct v as [ x | t | ]; simpl.
  - apply Hfg.
  - erewrite tmonad_bind_map; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hfg, vmonad_map_map'.
    symmetry; apply vmonad_map_map; reflexivity.
  - reflexivity.
Qed.

Lemma emonad_bind_map {A B B' C : Set} (E : ectx A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  ebind f₂ (emap f₁ E) = emap g₂ (ebind g₁ E).
Proof.
intros f₁ f₂ g₁ g₂ Hfg; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; erewrite tmonad_bind_map; [ | eassumption ].
  reflexivity.
+ rewrite IHE; erewrite vmonad_bind_map; [ | eassumption ].
  reflexivity.
Qed.

Lemma mmonad_bind_map {A B B' C : Set} (F : mctx A) :
  ∀ (f₁ : A → B) (f₂ : B → value C) (g₁ : A → value B') (g₂ : B' → C),
  (∀ x, f₂ (f₁ x) = vmap g₂ (g₁ x)) →
  mbind f₂ (mmap f₁ F) = mmap g₂ (mbind g₁ F).
Proof.
intros f₁ f₂ g₁ g₂ Hfg; induction F as [ | F IHF t | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF; erewrite tmonad_bind_map; [ | eassumption ].
  reflexivity.
+ rewrite IHF; erewrite vmonad_bind_map; [ | eassumption ].
  reflexivity.
+ rewrite IHF; reflexivity.
Qed.

Fixpoint tmonad_bind_bind {A B B' C : Set} (t : term A) :
  ∀ (f₁ : A → value B) (f₂ : B → value C)
    (g₁ : A → value B') (g₂ : B' → value C),
  (∀ x, vbind f₂ (f₁ x) = vbind g₂ (g₁ x)) →
  tbind f₂ (tbind f₁ t) = tbind g₂ (tbind g₁ t)
with vmonad_bind_bind {A B B' C : Set} (v : value A) :
  ∀ (f₁ : A → value B) (f₂ : B → value C)
    (g₁ : A → value B') (g₂ : B' → value C),
  (∀ x, vbind f₂ (f₁ x) = vbind g₂ (g₁ x)) →
  vbind f₂ (vbind f₁ v) = vbind g₂ (vbind g₁ v).
Proof.
+ intros f₁ f₂ g₁ g₂ Hfg; destruct t as [ v | t s | t ]; simpl.
  - erewrite vmonad_bind_bind; [ | eassumption ]; reflexivity.
  - erewrite (tmonad_bind_bind _ _ _ _ t f₁ f₂); [ | eassumption ].
    erewrite (tmonad_bind_bind _ _ _ _ s f₁ f₂); [ | eassumption ].
    reflexivity.
  - erewrite tmonad_bind_bind; [ reflexivity | eassumption ].
+ intros f₁ f₂ g₁ g₂ Hfg; destruct v as [ x | t | ]; simpl.
  - apply Hfg.
  - erewrite tmonad_bind_bind; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    erewrite (vmonad_bind_map (f₁ x) _ _ f₂); simpl; [ | reflexivity ].
    rewrite Hfg.
    symmetry; apply vmonad_bind_map; reflexivity.
  - reflexivity.
Qed.

Fixpoint tmonad_bind_return {A : Set} (t : term A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → tbind f t = t
with vmonad_bind_return {A : Set} (v : value A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → vbind f v = v.
Proof.
+ intros f Hf; destruct t as [ v | t s | t ]; simpl.
  - rewrite vmonad_bind_return; [ reflexivity | assumption ].
  - rewrite tmonad_bind_return; [ | assumption ].
    rewrite tmonad_bind_return; [ | assumption ].
    reflexivity.
  - rewrite tmonad_bind_return; [ reflexivity | assumption ].
+ intros f Hf; destruct v as [ x | t | ]; simpl.
  - apply Hf.
  - rewrite tmonad_bind_return; [ reflexivity | ].
    intros [ | x ]; simpl; [ reflexivity | ].
    rewrite Hf; reflexivity.
  - reflexivity.
Qed.

Lemma emonad_bind_return {A : Set} (E : ectx A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → ebind f E = E.
Proof.
intros f Hf; induction E as [ | E IHE t | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE, tmonad_bind_return; auto.
+ rewrite IHE, vmonad_bind_return; auto.
Qed.

Lemma mmonad_bind_return {A : Set} (F : mctx A) :
  ∀ (f : A → value A), (∀ x, f x = val_var x) → mbind f F = F.
Proof.
intros f Hf; induction F as [ | F IHF t | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF, tmonad_bind_return; auto.
+ rewrite IHF, vmonad_bind_return; auto.
+ rewrite IHF; auto.
Qed.

Lemma tmonad_bind_return' {A : Set} (t : term A) :
  tbind (@val_var A) t = t.
Proof.
apply tmonad_bind_return; reflexivity.
Qed.

Lemma vmonad_bind_return' {A : Set} (v : value A) :
  vbind (@val_var A) v = v.
Proof.
apply vmonad_bind_return; reflexivity.
Qed.

Lemma emonad_bind_return' {A : Set} (E : ectx A) :
  ebind (@val_var A) E = E.
Proof.
apply emonad_bind_return; reflexivity.
Qed.

Lemma mmonad_bind_return' {A : Set} (F : mctx A) :
  mbind (@val_var A) F = F.
Proof.
apply mmonad_bind_return; reflexivity.
Qed.

Lemma subst_vshift {V : Set} (v w : value V) :
  vshift v {v↦ w} = v.
Proof.
erewrite vmonad_bind_map.
+ rewrite vmonad_map_id'; apply vmonad_bind_return'.
+ intro x; reflexivity.
Qed.

Lemma subst_eshift {V : Set} E (v : value V) :
  eshift E {E↦ v} = E.
Proof.
erewrite emonad_bind_map.
+ rewrite emonad_map_id'; apply emonad_bind_return'.
+ intro x; reflexivity.
Qed.

Lemma subst_mshift {V : Set} F (v : value V) :
  mshift F {M↦ v} = F.
Proof.
erewrite mmonad_bind_map.
+ rewrite mmonad_map_id'; apply mmonad_bind_return'.
+ intro x; reflexivity.
Qed.

Lemma map_eplug {A B : Set} (f : A → B) (E : ectx A) (t : term A) :
  tmap f (E $[ t ]) = emap f E $[ tmap f t ].
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma map_mplug {A B : Set} (f : A → B) (F : mctx A) (t : term A) :
  tmap f (F $$[ t ]) = mmap f F $$[ tmap f t ].
Proof.
induction F as [ | F IHF s | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
Qed.

Lemma bind_eplug {A B : Set} (f : A → value B) (E : ectx A) (t : term A) :
  tbind f (E $[ t ]) = ebind f E $[ tbind f t ].
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma bind_mplug {A B : Set} (f : A → value B) (F : mctx A) (t : term A) :
  tbind f (F $$[ t ]) = mbind f F $$[ tbind f t ].
Proof.
induction F as [ | F IHF s | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
Qed.

Lemma map_ecomp {A B : Set} (f : A → B) (E E' : ectx A) :
  emap f (ecomp E E') = ecomp (emap f E) (emap f E').
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity.
Qed.

Lemma map_mcomp {A B : Set} (f : A → B) (F F' : mctx A) :
  mmap f (mcomp F F') = mcomp (mmap f F) (mmap f F').
Proof.
induction F as [ | F IHF s | v F IHF | F IHF ]; simpl.
+ reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
+ rewrite IHF; reflexivity.
Qed.

Lemma bind_mcomp {A B : Set} (f : A → value B) (F F' : mctx A) :
  mbind f (mcomp F F') = mcomp (mbind f F) (mbind f F').
Proof.
induction F; simpl; congruence.
Qed.

Lemma ecomp_eplug {V : Set} (E₁ E₂ : ectx V) (t : term V) :
  (ecomp E₁ E₂) $[ t ] = E₁ $[ E₂ $[ t ] ].
Proof.
induction E₁; simpl; congruence.
Qed.

Lemma mcomp_mplug {V : Set} (F₁ F₂ : mctx V) (t : term V) :
  (mcomp F₁ F₂) $$[ t ] = F₁ $$[ F₂ $$[ t ] ].
Proof.
induction F₁; simpl; congruence.
Qed.

Lemma ecomp_mt {V : Set} (E : ectx V) :
  ecomp E ectx_mt = E.
Proof.
induction E; simpl; congruence.
Qed.

Lemma mcomp_assoc {V : Set} (F₁ F₂ F₃ : mctx V) :
  mcomp (mcomp F₁ F₂) F₃ = mcomp F₁ (mcomp F₂ F₃).
Proof.
induction F₁; simpl; congruence.
Qed.

Lemma mmap_pure {A B : Set} (f : A → B) (E : ectx A) :
  mmap f E = emap f E.
Proof.
induction E as [ | E IHE s | v E IHE ]; simpl.
+ reflexivity.
+ rewrite IHE; reflexivity.
+ rewrite IHE; reflexivity. 
Qed.

Lemma mbind_pure {A B : Set} (f : A → value B) (E : ectx A) :
  mbind f E = ebind f E.
Proof.
induction E; simpl; congruence.
Qed.

Lemma mplug_pure {V : Set} (E : ectx V) (t : term V) :
  E $$[ t ] = E $[ t ].
Proof.
induction E; simpl; congruence.
Qed.

Lemma mcomp_pure {V : Set} (E₁ E₂ : ectx V) :
  mcomp E₁ E₂ = ecomp E₁ E₂.
Proof.
induction E₁; simpl; congruence.
Qed.

Lemma mctx_case {V : Set} (F : mctx V) :
  (∃ E : ectx V, F = E) ∨
  (∃ (F' : mctx V) (E : ectx V), F = mcomp F' (mctx_rst E)).
Proof.
induction F as [ | F IHF t | v F IHF | F IHF ].
+ left; exists ectx_mt; reflexivity.
+ destruct IHF as [ [ E H ] | [ F' [ E H ] ] ]; subst.
  - left; exists (ectx_app1 E t); reflexivity.
  - right; exists (mctx_app1 F' t); exists E; reflexivity.
+ destruct IHF as [ [ E H ] | [ F' [ E H ] ] ]; subst.
  - left; exists (ectx_app2 v E); reflexivity.
  - right; exists (mctx_app2 v F'); exists E; reflexivity.
+ destruct IHF as [ [ E H ] | [ F' [ E H ] ] ]; right; subst.
  - exists mctx_mt; exists E; reflexivity.
  - exists (mctx_rst F'); exists E; reflexivity.
Qed.

Lemma mctx_pure_no_rst {V : Set} (F : mctx V) (E E' : ectx V) :
  mcomp F (mctx_rst E) = E' → False.
Proof.
generalize E'; clear E'; induction F as [ | F IHF t | v F IHF | F IHF ];
  simpl; intro E'; destruct E'; try discriminate.
+ intro Heq; injection Heq; intro; apply IHF.
+ intro Heq; injection Heq; intros Heq₁ Heq₂.
  apply IHF in Heq₁; destruct Heq₁.
Qed.

Lemma mctx_pure_unique {V : Set} (E₁ E₂ : ectx V) :
  mctx_pure E₁ = mctx_pure E₂ → E₁ = E₂.
Proof.
generalize E₂; clear E₂; induction E₁ as [ | E₁ IHE t | v E₁ IHE ];
  destruct E₂; simpl; try discriminate.
+ auto.
+ intro Heq; injection Heq; clear Heq.
  intros Heq₁ Heq₂; apply IHE in Heq₂; subst; reflexivity.
+ intro Heq; injection Heq; clear Heq.
  intros Heq₁ Heq₂; apply IHE in Heq₁; subst; reflexivity.
Qed.

Lemma mctx_rst_unique {V : Set} (F₁ F₂ : mctx V) (E₁ E₂ : ectx V) :
  mcomp F₁ (mctx_rst E₁) = mcomp F₂ (mctx_rst E₂) → F₁ = F₂ ∧ E₁ = E₂.
Proof.
generalize F₂; clear F₂.
induction F₁ as [ | F₁ IHF t₁ | v F₁ IHF | F₁ IHF ];
  simpl; intro F₂; destruct F₂; simpl; try discriminate.
+ intro Heq; injection Heq; clear Heq.
  intro Heq; apply mctx_pure_unique in Heq; split; auto.
+ intro Heq; injection Heq; clear Heq.
  intro Heq; symmetry in Heq; apply mctx_pure_no_rst in Heq; destruct Heq.
+ intro Heq; injection Heq; clear Heq.
  intros Heq₁ Heq₂; apply IHF in Heq₂; destruct Heq₂; subst; auto.
+ intro Heq; injection Heq; clear Heq.
  intros Heq₁ Heq₂; apply IHF in Heq₁; destruct Heq₁; subst; auto.
+ intro Heq; injection Heq; clear Heq.
  intro Heq; apply mctx_pure_no_rst in Heq; destruct Heq.
+ intro Heq; injection Heq; clear Heq.
  intro Heq; apply IHF in Heq; destruct Heq; subst; auto.
Qed.