Require Import Utf8.
Require Import Lang TermRelation UpToTechniques.
Require Import Le Max.

Lemma var_finite : finite var.
Proof.
intros f Hf R V _ _ [ x ].
exists 1; right; apply Hf; constructor.
Qed.

Lemma var2_finite : finite var2.
Proof.
intros f Hf R V _ _ [ x y ].
exists 1; right; apply Hf; constructor.
Qed.

Lemma lam_finite : finite lam.
Proof.
intros f Hf R V _ _ [ t₁ t₂ Ht ].
destruct Ht as [ n Ht ].
exists (1+n); right; apply Hf; constructor; assumption.
Qed.

Lemma sft_finite : finite sft.
Proof.
intros f Hf R V _ _ [ ].
exists 1; right; apply Hf; constructor.
Qed.

Lemma sft2_finite : finite sft2.
Proof.
intros f Hf R V _ _ [ x ].
exists 1; right; apply Hf; constructor.
Qed.

Lemma app_finite : finite app.
Proof.
intros f Hf R V _ _ [ t₁ t₂ s₁ s₂ Ht Hs ].
destruct Ht as [ n Ht ]; destruct Hs as [ m Hs ].
exists (1+max n m); right; apply Hf; constructor.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_l.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_r.
Qed.

Lemma subst_finite : finite subst.
Proof.
intros f Hf R V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ].
destruct Ht as [ n Ht ]; destruct Hv as [ m Hv ].
exists (1+max n m); right; apply Hf; constructor.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_l.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_r.
Qed.

Lemma ectxr_finite : finite ectxr.
Proof.
intros f Hf R V _ _ [ E₁ E₂ t₁ t₂ HE Ht ].
destruct HE as [ n HE ]; destruct Ht as [ m Ht ].
exists (1+max n m); right; apply Hf; constructor.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_l.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_r.
Qed.

Lemma ectxrst_finite : finite ectxrst.
Proof.
intros f Hf R V _ _ [ E₁ E₂ t₁ t₂ HE Ht ].
destruct HE as [ n HE ]; destruct Ht as [ m Ht ].
exists (1+max n m); right; apply Hf; constructor.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_l.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_r.
Qed.

Lemma mctxvpure_finite : finite mctxvpure.
Proof.
intros f Hf R V _ _ [ F₁ F₂ t₁ t₂ Hp₁ Hp₂ HF Ht ].
destruct HF as [ n HF ]; destruct Ht as [ m Ht ].
exists (1+max n m); right; apply Hf; constructor.
+ assumption.
+ assumption.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_l.
+ eapply iter_monotone_n; [ | eassumption ].
  apply le_max_r.
Qed.

Lemma map_finite : finite map.
Proof.
intros f Hf R V _ _ [ W t₁ t₂ g Ht ].
destruct Ht as [ n Ht ].
exists (1+n); right; apply Hf; constructor; assumption.
Qed.

Lemma redr_finite : finite redr.
Proof.
intros f Hf R V t₁ t₂ [ t₁' t₂' Hred₁ Hred₂ Ht ].
destruct Ht as [ n Ht ].
exists (1+n); right; apply Hf; econstructor; eassumption.
Qed.