Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques Monotonicity.
Require Import LangProperties UpToMap.

Lemma ectx_rel_comp {V : Set} (R : term_rel) (E₁ E₂ E₁' E₂' : ectx V) :
  ectx_rel R V E₁ E₂ → ectx_rel R V E₁' E₂' →
  ectx_rel (ectxr (map R)) V (ecomp E₁ E₁') (ecomp E₂ E₂').
Proof.
intros HE HE'; unfold ectx_rel.
rewrite map_ecomp, map_ecomp, ecomp_eplug, ecomp_eplug.
constructor.
+ apply ectx_rel_map; assumption.
+ apply Mk_map_id; assumption.
Qed.

Lemma ectx_rst_rel_comp {V : Set} (R : term_rel) (E₁ E₂ E₁' E₂' : ectx V) :
  ectx_rst_rel R V E₁ E₂ → ectx_rel R V E₁' E₂' →
  ectx_rst_rel (ectxrst (map R)) V (ecomp E₁ E₁') (ecomp E₂ E₂').
Proof.
intros HE HE'; unfold ectx_rst_rel.
rewrite map_ecomp, map_ecomp, ecomp_eplug, ecomp_eplug.
constructor.
+ apply ectx_rst_rel_map; assumption.
+ apply Mk_map_id; assumption.
Qed.

Lemma ectx_rel_comp_mctx_val {V : Set} (R : term_rel)
    (E₁ E₂ : ectx V) (F₁ F₂ : mctx V) :
  ectx_rel R V E₁ E₂ → mctx_val_rel R V F₁ F₂ →
  mctx_val_rel ((ectxr ◦ map) R) V (mcomp E₁ F₁) (mcomp E₂ F₂).
Proof.
intros HE HF; unfold mctx_val_rel.
rewrite map_mcomp, map_mcomp, mcomp_mplug, mcomp_mplug.
rewrite mmap_pure, mmap_pure, mplug_pure, mplug_pure.
constructor.
+ apply ectx_rel_map; assumption.
+ apply Mk_map_id; assumption.
Qed.

Lemma ectx_rel_comp_mctx {V : Set} (R : term_rel)
    (E₁ E₂ : ectx V) (F₁ F₂ : mctx V) :
  ectx_rel R V E₁ E₂ → mctx_rel R V F₁ F₂ →
  mctx_rel ((id ∪ (ectxr ◦ map)) R) V (mcomp E₁ F₁) (mcomp E₂ F₂).
Proof.
intros HE HF; destruct HF as [ E₁' E₂' HE' | F₁ F₂ E₁' E₂' HE' HF ].
+ rewrite mcomp_pure, mcomp_pure; constructor 1.
  eapply ectx_rel_monotone; [ | apply ectx_rel_comp; eassumption ].
  apply sum_sub_r; auto.
+ rewrite <- mcomp_assoc, <- mcomp_assoc; constructor 2.
  - eapply ectx_rst_rel_monotone; [ | eassumption ].
    apply sum_sub_l; auto.
  - eapply mctx_val_rel_monotone;
      [ | apply ectx_rel_comp_mctx_val; eassumption ].
    apply sum_sub_r; auto.
Qed.

Lemma ectx_rst_rel_comp_mctx {V : Set} (R : term_rel)
    (E₁ E₂ : ectx V) (F₁ F₂ : mctx V) :
  ectx_rst_rel R V E₁ E₂ → mctx_rel R V F₁ F₂ →
  mctx_rel ((id ∪ (var ∪ (ectxrst ◦ map))) R) V
    (mctx_rst (mcomp E₁ F₁)) (mctx_rst (mcomp E₂ F₂)).
Proof.
intros HE HF; destruct HF as [ E₁' E₂' HE' | F₁ F₂ E₁' E₂' HE' HF ].
+ rewrite mcomp_pure, mcomp_pure.
  apply (mctx_rel_reset _ _ mctx_mt mctx_mt).
  - unfold ectx_rst_rel; right; right.
    rewrite map_ecomp, map_ecomp, ecomp_eplug, ecomp_eplug.
    constructor.
    * apply ectx_rst_rel_map; assumption.
    * apply Mk_map_id; assumption.
  - right; left; constructor.
+ rewrite <- mcomp_assoc, <- mcomp_assoc.
  apply (mctx_rel_reset _ _ (mctx_rst _) (mctx_rst _)).
  - left; assumption.
  - unfold mctx_val_rel; simpl; right; right.
    rewrite map_mcomp, map_mcomp, mcomp_mplug, mcomp_mplug.
    rewrite mmap_pure, mmap_pure, mplug_pure, mplug_pure.
    constructor.
    * apply ectx_rst_rel_map; assumption.
    * apply Mk_map_id; assumption.
Qed.

Lemma mctx_val_rel_comp_mctxvpure {V : Set} (R : term_rel)
    (F₁ F₂ F₁' F₂' : mctx V) :
  mctx_val_rel R V F₁ F₂ → mctx_rel R V (mctx_rst F₁') (mctx_rst F₂') →
  mctx_rel ((id ∪ (mctxvpure ◦ map)) R) V
    (mcomp F₁ (mctx_rst F₁')) (mcomp F₂ (mctx_rst F₂')).
Proof.
intros HF HF'; inversion HF' as [ E₁ E₂ HE | G₁ G₂ E₁ E₂ HE HG ].
  { destruct E₁; discriminate. }
rewrite <- mcomp_assoc, <- mcomp_assoc; constructor.
+ left; assumption.
+ unfold mctx_val_rel; right.
  rewrite map_mcomp, map_mcomp, mcomp_mplug, mcomp_mplug.
  constructor.
  - destruct G₁; try discriminate; constructor.
  - destruct G₂; try discriminate; constructor.
  - apply mctx_val_rel_map; assumption.
  - apply Mk_map_id; assumption.
Qed.