Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import Reduction.

Lemma var_passive_evolution (R Q : term_rel) :
  var R ⊆ passive_step ((var ∪ var2) Q).
Proof.
intros V _ _ [ x ]; split.
+ left; constructor.
+ intro v₁; intro Heq; injection Heq; clear Heq.
  intro Heq; rewrite <- Heq; clear Heq.
  exists (val_var x); split; [ constructor 1 | ].
  right; constructor.
Qed.

Lemma var_active_evolution (R S : term_rel) :
  var R ⊆ active_step (var S).
Proof.
intros V _ _ [ x ]; split.
+ constructor.
+ intros t₁ Hred; exfalso.
  inversion Hred.
+ intros [] ? ? Heq; discriminate.
Qed.

Lemma var_evolution : var !↝ var ∪ var2 & var.
Proof.
intros R Q S Hp; split.
+ apply var_passive_evolution.
+ apply var_active_evolution.
Qed.

Lemma var2_passive_evolution (R Q : term_rel) :
  var2 R ⊆ passive_step (var2 Q).
Proof.
intros V _ _ [ x y ]; split.
+ constructor.
+ intros v₁ Heq; discriminate.
Qed.

Lemma var2_active_evolution (R S : term_rel) :
  var2 R ⊆ active_step ((var ∪ var2) S).
Proof.
intros V _ _ [ x y ]; split.
+ right; constructor.
+ intros t₁ Hred; exfalso.
  apply (open_is_stuck ectx_mt) in Hred; assumption.
+ intros E₁ z v₁ Heq; symmetry in Heq.
  apply (open_stuck_unique _ ectx_mt) in Heq.
  destruct Heq as [ ? [ ? ? ] ]; subst.
  exists ectx_mt; exists (val_var y); split; [ | split ].
  - constructor 1.
  - left; constructor.
  - right; constructor.
Qed.

Lemma var2_evolution : var2 !↝ var2 & (var ∪ var2).
Proof.
intros R Q S Hp; split.
+ apply var2_passive_evolution.
+ apply var2_active_evolution.
Qed.