Require Import Utf8.
Require Import Lang TermRelation Simulation.
Require Import LangProperties.

Inductive var (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_var : ∀ x : V, var R V (val_var x) (val_var x)
.

Inductive var2 (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_var2 : ∀ x y : V,
    var2 R V (tm_app (val_var x) (val_var y))
             (tm_app (val_var x) (val_var y))
.

Inductive lam (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_lam : ∀ (t₁ t₂ : term (inc V)),
    R _ t₁ t₂ →
    lam R _ (val_lam t₁) (val_lam t₂)
.

Inductive app (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_app : ∀ (t₁ t₂ s₁ s₂ : term V),
    R V t₁ t₂ → R V s₁ s₂ → app R V (tm_app t₁ s₁) (tm_app t₂ s₂)
.

Inductive subst (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_subst : ∀ (t₁ t₂ : term (inc V)) (v₁ v₂ : value V),
    R _ t₁ t₂ →
    val_rel R _ v₁ v₂ →
    subst R V (t₁ {t↦ v₁}) (t₂ {t↦ v₂})
.

Inductive ectxr (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_ectxr : ∀ (E₁ E₂ : ectx V) (t₁ t₂ : term V),
    ectx_rel R _ E₁ E₂ →
    R _ t₁ t₂ →
    ectxr R V (E₁ $[ t₁ ]) (E₂ $[ t₂ ])
.

Inductive map (R : term_rel) (V : Set) : term V → term V → Prop :=
| Mk_map : ∀ (W : Set) (t₁ t₂ : term W) (f : W → V),
    R _ t₁ t₂ →
    map R V (tmap f t₁) (tmap f t₂)
.

Inductive redr (R : term_rel) (V : Set) (t₁ t₂ : term V) : Prop :=
| Mk_redr : ∀ t₁' t₂' : term V,
    red_rtc t₁ t₁' →
    red_rtc t₂ t₂' →
    R V t₁' t₂' →
    redr R V t₁ t₂
.

Lemma Mk_map_id (R : term_rel) {V : Set} {t₁ t₂ : term V} :
  R _ t₁ t₂ → map R _ t₁ t₂.
Proof.
intro HR; apply Mk_map with (f := λ x, x) in HR.
repeat rewrite tmonad_map_id' in HR; assumption.
Qed.

Lemma Mk_appV (R : term_rel) {V : Set} {v₁ v₂ : value V} {t₁ t₂ : term V} :
    val_rel R _ v₁ v₂ →
    R _ t₁ t₂ →
    ectxr R V (tm_app v₁ t₁) (tm_app v₂ t₂).
Proof.
intros Hv Ht.
change (ectxr R V (ectx_app2 v₁ ectx_mt $[ t₁ ])
  (ectx_app2 v₂ ectx_mt $[ t₂ ])).
constructor; assumption.
Qed.