Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import LangProperties Reduction Monotonicity.
Require Import UpToMap.

Definition subst_act : term_rel → term_rel :=
  (  subst
   ∪ (subst ◦ map ◦ (id ∪ (subst ◦ map)))
  ) ∪ (
    (ectxr ◦ subst ◦ (map ∪ (subst ◦ map)))
   ∪ (ectxr ◦ ((map ◦ subst ◦ map) ∪ (subst ◦ map ◦ (id ∪ (subst ◦ map)))))
  ).

Definition swap_01 {V : Set} (x : inc (inc V)) : inc (inc V) :=
  match x with
  | VZ        => VS VZ
  | VS VZ     => VZ
  | VS (VS y) => VS (VS y)
  end.

Lemma val_rel_subst (R : term_rel) (V : Set)
    (v₁ v₂ : value (inc V)) (w₁ w₂ : value V) :
  val_rel R _ v₁ v₂ →
  val_rel R _ w₁ w₂ →
  val_rel (subst (map R)) _ (v₁ {v↦ w₁ }) (v₂ {v↦ w₂ }).
Proof.
intros Hv Hw.
unfold val_rel; simpl; unfold val_rel in Hv.
apply Mk_map with (f := swap_01) in Hv.
apply Mk_subst with (v₁ := vshift w₁) (v₂ := vshift w₂) in Hv.
+ simpl in Hv.
  rewrite vmonad_map_map', vmonad_map_map' in Hv.
  erewrite vmonad_bind_map, vmonad_bind_map in Hv.
  - exact Hv.
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma ectx_rel_subst (R : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (v₁ v₂ : value V) :
  ectx_rel R _ E₁ E₂ →
  val_rel  R _ v₁ v₂ →
  ectx_rel (subst (map R)) _ (E₁ {E↦ v₁}) (E₂ {E↦ v₂}).
Proof.
intros HE Hv.
unfold ectx_rel; unfold ectx_rel in HE.
apply Mk_map with (f := swap_01) in HE.
apply Mk_subst with (v₁ := vshift v₁) (v₂ := vshift v₂) in HE.
+ rewrite map_eplug, map_eplug in HE; simpl in HE.
  rewrite emonad_map_map', emonad_map_map' in HE.
  rewrite bind_eplug, bind_eplug in HE; simpl in HE.
  erewrite emonad_bind_map, emonad_bind_map in HE; [ exact HE | | ].
  - intros [ | x ]; reflexivity.
  - intros [ | x ]; reflexivity.
+ apply val_rel_map; assumption.
Qed.

Lemma subst_passive_evolution (R S : term_rel) :
  R ↣ R & S → subst R ⊆ passive_step (subst (map R)).
Proof.
intros HRS V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; split.
+ constructor.
  - apply Mk_map_id; assumption.
  - unfold val_rel; apply Mk_map_id; assumption.
+ intros w₀ Heq.
  destruct t₁ as [ w₁ | ]; try discriminate.
  injection Heq; clear Heq; intro; subst.
  apply (progress_value HRS) in Ht.
  destruct Ht as [ w₂ [ Hred_t Hw ] ].
  exists (w₂ {v↦ v₂}); split.
  - change (red_rtc (t₂ {t↦v₂}) (w₂ {t↦v₂})).
    apply red_rtc_subst; assumption.
  - apply val_rel_subst; assumption.
Qed.

Lemma subst_active_open_step (R S : term_rel) (V : Set)
  (v₁ v₂ : value V) (E₁ : ectx (inc V)) x (w₁ : value (inc V)) (t₁' : term V)
  (t₂ : term (inc V)) :
  (R ↣ R & S) →
  R _ (E₁ $[ tm_app (val_var x) w₁ ]) t₂ →
  val_rel R _ v₁ v₂ →
  red (E₁ $[ tm_app (val_var x) w₁ ] {t↦ v₁}) t₁' →
  ∃ t₂' : term V, red_rtc (t₂ {t↦ v₂}) t₂'
    ∧ subst_act S _ t₁' t₂'.
Proof.
intros HRS Ht Hv Hred₁.
apply (progress_open HRS) in Ht.
destruct Ht as [ E₂ [ w₂ [ Hred₂ [ HE Hw ] ] ] ].
rewrite bind_eplug in Hred₁; simpl in Hred₁.
apply red_eplug_app in Hred₁.
destruct Hred₁ as [ r₁ [ Heq Hred₁ ] ]; subst.
destruct x as [ | x ]; simpl in Hred₁;
  [ | apply (open_is_stuck ectx_mt) in Hred₁; destruct Hred₁ ].
destruct v₁ as [ z | t₁ ];
  [ apply (open_is_stuck ectx_mt) in Hred₁; destruct Hred₁ | ].
inversion Hred₁; subst; clear Hred₁;
  try match goal with
  [ H: red (tm_val _) _ |- _ ] => inversion H
  end.
assert (Ht := Hv); unfold val_rel in Ht; simpl in Ht.
eapply (progress_step HRS) in Ht; [ | apply red_beta ].
destruct Ht as [ t₂' [ Hred₂' Ht' ] ].
apply red_rtc_subst with (v := v₂) in Hred₂.
rewrite bind_eplug in Hred₂; simpl in Hred₂.
apply red_rtc_subst with (v := w₂ {v↦ v₂ }) in Hred₂'; simpl in Hred₂'.
rewrite subst_vshift in Hred₂'.
exists (E₂ {E↦ v₂} $[ t₂' {t↦ w₂ {v↦ v₂}} ]); split.
{ eapply red_rtc_trans; [ eassumption | ].
  apply red_rtc_in_ectx; assumption.
}
right; left; constructor.
+ eapply ectx_rel_monotone; [ | apply ectx_rel_subst; [ eassumption | ] ].
  - apply subst_monotone; unfold trf_sum; auto.
  - apply (progress_sub_active HRS); assumption.
+ rewrite tmonad_bind_map with (g₁ := @val_var _) (g₂ := λ x, x) in Ht';
    [ | intros [ | ]; reflexivity ].
  rewrite tmonad_map_id', tmonad_bind_return' in Ht'.
  constructor; [ left; apply Mk_map_id; assumption | ].
  eapply val_rel_monotone; [ | apply val_rel_subst ];
    [ | eassumption | apply (progress_sub_active HRS); assumption ].
  unfold trf_sum; auto.
Qed.

Lemma subst_active_open_sub (R S : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (w₁ w₂ : value (inc V))
    (t₂ : term (inc V)) (x : V) (v₂ : value V) :
  R ↣ R & S →
  ectx_rel S (inc V) E₁ E₂ →
  val_rel S (inc V) w₁ w₂ →
  val_rel R V (val_var x) v₂ →
  red_rtc t₂ (E₂ $[ tm_app (val_var VZ) w₂ ]) →
  ∃ E₂' (v₂' : value _),
             red_rtc (t₂ {t↦ v₂}) (E₂' $[ tm_app (val_var x) v₂' ])
           ∧ ectx_rel (subst_act S) _ (E₁ {E↦ val_var x}) E₂'
           ∧ val_rel  (subst_act S) _ (w₁ {v↦ val_var x}) v₂'.
Proof.
intros HRS HE Hw Hv Hred.
apply red_rtc_subst with (v := v₂) in Hred.
rewrite bind_eplug in Hred; simpl in Hred.
assert (Hx := Hv); unfold val_rel in Hx.
apply (progress_open HRS ectx_mt) in Hx.
destruct Hx as [ E₂' [ u₂ [ Hred' [ HE' Hu ] ] ] ].
apply red_rtc_subst with (v := w₂ {v↦ v₂}) in Hred'.
rewrite bind_eplug in Hred'; simpl in Hred'.
rewrite subst_vshift in Hred'.
exists (ecomp (E₂ {E↦ v₂}) (E₂' {E↦ w₂ {v↦ v₂}})).
exists (u₂ {v↦ w₂ {v↦ v₂}}).
split; [ | split ].
+ rewrite ecomp_eplug.
  eapply red_rtc_trans; [ eassumption | ].
  apply red_rtc_in_ectx; assumption.
+ unfold ectx_rel; rewrite map_ecomp, ecomp_eplug.
  right; right; constructor.
  - eapply ectx_rel_monotone; [ intros ? ? ? HS; left; exact HS | ].
    apply ectx_rel_map, ectx_rel_subst; [ assumption | ].
    eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
  - right.
    match goal with
    [ |- ?r ?t1 ?t2 ] =>
      change (r (eshift (ectx_mt {E↦ w₁ {v↦ val_var x}}) $[ t1 ]) t2)
    end.
    apply ectx_rel_subst.
    * eapply ectx_rel_monotone; [ | eassumption ].
      unfold trf_sum; auto.
    * { eapply val_rel_monotone; [ | apply val_rel_subst; [ eassumption | ] ].
      + unfold trf_sum; auto.
      + eapply val_rel_monotone; [ | eassumption ].
        apply (progress_sub_active HRS).
      }
+ change (val_rel (subst_act S) V
    ((val_var VZ) {v↦ w₁ {v↦ val_var x}})
    (u₂           {v↦ w₂ {v↦ v₂}})).
  eapply val_rel_monotone; [ | apply val_rel_subst ];
    [ | | eapply val_rel_monotone; 
          [ | apply val_rel_subst; [ eassumption | ] ] ].
  - intros; left; right; eassumption.
  - eapply val_rel_monotone; [ | eassumption ].
    unfold trf_sum; auto.
  - intros; right; assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
Qed.

Lemma subst_active_open_old (R S : term_rel) (V : Set)
    (E₁ E₂ : ectx (inc V)) (w₁ w₂ : value (inc V)) (v₁ v₂ : value V)
    (t₂ : term (inc V)) (x : V) :
  R ↣ R & S →
  ectx_rel S (inc V) E₁ E₂ →
  val_rel S (inc V) w₁ w₂ →
  val_rel R V v₁ v₂ →
  red_rtc t₂ (E₂ $[ tm_app (val_var (VS x)) w₂ ]) →
  ∃ E₂' (v₂' : value _),
             red_rtc (t₂ {t↦ v₂}) (E₂' $[ tm_app (val_var x) v₂' ])
           ∧ ectx_rel (subst_act S) _ (E₁ {E↦ v₁}) E₂'
           ∧ val_rel  (subst_act S) _ (w₁ {v↦ v₁}) v₂'.
Proof.
intros HRS HE Hw Hv Hred.
apply red_rtc_subst with (v := v₂) in Hred.
rewrite bind_eplug in Hred; simpl in Hred.
exists (E₂ {E↦ v₂}); exists (w₂ {v↦ v₂}); split; [ | split ].
+ assumption.
+ eapply ectx_rel_monotone; [ | apply ectx_rel_subst; [ eassumption | ] ].
  - intros; left; right.
    eapply subst_monotone; [ | eassumption ].
    eapply map_monotone; unfold trf_sum; auto.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
+ eapply val_rel_monotone; [ | apply val_rel_subst; [ eassumption | ] ].
  - intros; left; right.
    eapply subst_monotone; [ | eassumption ].
    eapply map_monotone; unfold trf_sum; auto.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
Qed.

Lemma subst_active_evolution (R S : term_rel) :
  R ↣ R & S →
  subst R ⊆ active_step (subst_act S).
Proof.
intros HRS V _ _ [ t₁ t₂ v₁ v₂ Ht Hv ]; split.
+ left; left; constructor.
  - apply (progress_sub_active HRS); assumption.
  - eapply val_rel_monotone; [ | eassumption ].
    apply (progress_sub_active HRS).
+ destruct (classify t₁) as [ v | t₁ t₁' Hred₁ | E₁ x w₁ ].
  - intros ? Hred; inversion Hred.
  - eapply (progress_step HRS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    apply red_subst with (v := v₁) in Hred₁.
    intros t₀ Hred'.
    eapply red_determ in Hred'; [ | exact Hred₁ ]; subst.
    exists (t₂' {t↦ v₂}); split.
    * apply red_rtc_subst; assumption.
    * left; left; constructor; [ assumption | ].
      eapply val_rel_monotone; [ | eassumption ].
      apply (progress_sub_active HRS).
  - intros; eapply subst_active_open_step; eassumption.
+ destruct (classify t₁) as [ v | t₁ t₁' Hred₁ | E₁ x w₁ ].
  - intros E x w Heq; exfalso; simpl in Heq.
    destruct E; discriminate.
  - intros E x v Heq; exfalso.
    apply (red_subst _ _ v₁) in Hred₁; rewrite Heq in Hred₁.
    apply open_is_stuck in Hred₁; assumption.
  - apply (progress_open HRS) in Ht.
    destruct Ht as [ E₂ [ w₂ [ Hred₂ [ HE Hw ] ] ] ].
    intros E₁' z w₁' Heq.
    rewrite bind_eplug in Heq; simpl in Heq.
    destruct x as [ | x ]; simpl in Heq;
      [ destruct v₁ as [ y | t₁ ]; simpl in Heq | ].
    * apply open_stuck_unique in Heq.
      destruct Heq as [ ? [ ? ? ] ]; subst.
      eapply subst_active_open_sub; eassumption.
    * exfalso; eapply (open_is_stuck E₁' z w₁').
      rewrite <- Heq; apply red_in_ectx, red_beta.
    * apply open_stuck_unique in Heq.
      destruct Heq as [ ? [ ? ? ] ]; subst.
      eapply subst_active_open_old; eassumption.
Qed.

Lemma subst_evolution : subst ↝ (subst ◦ map) & subst_act.
Proof.
intros R S HRS; split.
+ eapply subst_passive_evolution; eassumption.
+ eapply subst_active_evolution; eassumption.
Qed.