Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques.
Require Import LangProperties Reduction.

Lemma val_rel_map (R : term_rel) (A B : Set) (f : A → B) (v₁ v₂ : value A) :
  val_rel R _ v₁ v₂ →
  val_rel (map R) _ (vmap f v₁) (vmap f v₂).
Proof.
unfold val_rel; intro Hv.
repeat rewrite vmonad_map_map'.
apply Mk_map with (f := inc_map f) in Hv; simpl in Hv.
erewrite vmonad_map_map, vmonad_map_map in Hv.
+ exact Hv.
+ reflexivity.
+ reflexivity.
Qed.

Lemma ectx_rel_map (R : term_rel) (A B : Set) (f : A → B) (E₁ E₂ : ectx A) :
  ectx_rel R _ E₁ E₂ →
  ectx_rel (map R) _ (emap f E₁) (emap f E₂).
Proof.
unfold ectx_rel; intro HE.
repeat rewrite emonad_map_map'.
apply Mk_map with (f := inc_map f) in HE; simpl in HE.
rewrite map_eplug, map_eplug in HE.
erewrite emonad_map_map, emonad_map_map in HE.
+ exact HE.
+ reflexivity.
+ reflexivity.
Qed.

Lemma map_passive_evolution {R Q S : term_rel} :
  R ↣ Q & S → map R ⊆ passive_step (map Q).
Proof.
intros HRQS V _ _ [ W t₁ t₂ f Ht ]; split.
+ constructor; apply (progress_sub_passive HRQS); assumption.
+ destruct (classify t₁) as [ w₁ | t₁ t₁' Hred | E₁ x w₁ ].
  - intros v₁ Heq; injection Heq; clear Heq; intro Heq; subst.
    apply (progress_value HRQS) in Ht; destruct Ht as [ w₂ [ Hred Hw ] ].
    exists (vmap f w₂); split.
    * change (red_rtc (tmap f t₂) (tmap f w₂)).
      apply red_rtc_map; assumption.
    * apply val_rel_map; assumption.
  - apply (red_map _ _ f) in Hred.
    intros ? Heq; rewrite Heq in Hred; inversion Hred.
  - intros ? Heq; destruct E₁; discriminate.
Qed.

Lemma map_active_evolution {R Q S : term_rel} :
  R ↣ Q & S → map R ⊆ active_step (map S).
Proof.
intros HRQS V _ _ [ W t₁ t₂ f Ht ]; split.
+ constructor; apply (progress_sub_active HRQS); assumption.
+ destruct (classify t₁) as [ w₁ | t₁ t₁' Hred | E₁ x w₁ ].
  - intros ? Hred; simpl in Hred; inversion Hred.
  - eapply (progress_step HRQS) in Ht; [ | eassumption ].
    destruct Ht as [ t₂' [ Hred₂ Ht' ] ].
    intros s₁ Hred₁; eapply red_map in Hred.
    eapply red_determ in Hred₁; [ | exact Hred ]; subst.
    exists (tmap f t₂'); split.
    * apply red_rtc_map; assumption.
    * constructor; assumption.
  - intros ? Hred; rewrite map_eplug in Hred; simpl in Hred.
    apply open_is_stuck in Hred; destruct Hred.
+ destruct (classify t₁) as [ w₁ | t₁ t₁' Hred | E₁ x v₁ ].
  - intros E₁ x v₁ Heq; destruct E₁; discriminate.
  - intros E₁ x v₁ Heq; apply (red_map _ _ f) in Hred.
    rewrite Heq in Hred; apply open_is_stuck in Hred; destruct Hred.
  - intros F₁ z w₁ Heq; rewrite map_eplug in Heq; simpl in Heq.
    apply open_stuck_unique in Heq; destruct Heq as [ ? [ ? ? ] ]; subst.
    apply (progress_open HRQS) in Ht.
    destruct Ht as [ E₂ [ v₂ [ Hred₂ [ HE Hv ] ] ] ].
    exists (emap f E₂); exists (vmap f v₂); split; [ | split ].
    * apply (red_rtc_map _ _ f) in Hred₂.
      rewrite map_eplug in Hred₂; assumption.
    * apply ectx_rel_map; assumption.
    * apply val_rel_map; assumption.
Qed.

Lemma map_evolution : map !↝ map & map.
Proof.
intros R Q S HRS; split.
+ apply (map_passive_evolution HRS).
+ apply (map_active_evolution HRS).
Qed.