Require Import Utf8.
Require Import Lang TermRelation Simulation UpToTechniques Monotonicity.
Require Import Reduction LangProperties.
Require Import UpToEctx.

Definition app_act : term_rel → term_rel :=
  (app ∪ (app ◦ map)) ∪ (subst ∪ ectxr_act).

Lemma app_passive_evolution (R : term_rel) :
  app R ⊆ passive_step (app R).
Proof.
intros V _ _ [ t₁ t₂ s₁ s₂ HR₁ HR₂ ]; split.
+ constructor; assumption.
+ intros ? ?; discriminate.
Qed.

Lemma app_active_evolution (R S : term_rel) :
  R ↣ R & S → app R ⊆ active_step (app_act S).
Proof.
intros HRS V _ _ [ t₁ t₂ s₁ s₂ HR₁ HR₂ ]; split.
+ left; left; constructor; apply (progress_sub_active HRS); assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' Hred | E₁ x v₁ ].
  - destruct (progress_value HRS HR₁) as [ v₂ [ Hred_t Hv ] ].
    assert (HappV : ectxr R _ (tm_app v₁ s₁) (tm_app v₂ s₂)).
    { apply Mk_appV; assumption. }
    assert (HRS' := HRS); apply ectxr_evolution in HRS'.
    intros t₁' Hred; eapply (progress_step HRS') in HappV;
      [ | eassumption ].
    destruct HappV as [ t₂' [ Hred₂ Ht' ] ].
    exists t₂'; split.
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_app1; assumption.
    * unfold app_act, trf_sum; auto.
  - eapply (progress_step HRS) in HR₁; [ | eassumption ].
    destruct HR₁ as [ t₂' [ Hred₂ Ht' ] ].
    intros t₁'' Hred₁.
    eapply red_determ in Hred₁; [ | apply red_app1; eassumption ].
    subst.
    exists (tm_app t₂' s₂); split.
    * apply red_rtc_app1; assumption.
    * left; left; constructor; [ assumption | ].
      apply (progress_sub_active HRS); assumption.
  - intros ? Hred.
    exfalso; apply (open_is_stuck (ectx_app1 _ _)) in Hred; assumption.
+ destruct (classify t₁) as [ v₁ | t₁ t₁' | E₁ x v₁ ].
  - destruct (progress_value HRS HR₁) as [ v₂ [ Hred_t Hv ] ].
    assert (HappV : ectxr R _ (tm_app v₁ s₁) (tm_app v₂ s₂)).
    { apply Mk_appV; assumption. }
    assert (HRS' := HRS); apply ectxr_evolution in HRS'.
    intros E₁ x w₁ Heq; rewrite Heq in HappV.
    eapply (progress_open HRS') in HappV.
    destruct HappV as [ E₂ [ w₂ [ Hred₂ [ HE Hw ] ] ] ].
    exists E₂; exists w₂; split; [ | split ].
    * eapply red_rtc_trans; [ | eassumption ].
      apply red_rtc_app1; assumption.
    * eapply ectx_rel_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
    * eapply val_rel_monotone; [ | eassumption ].
      unfold app_act, trf_sum; auto.
  - intros E₁ x v₁ Heq; exfalso.
    eapply (open_is_stuck E₁ x v₁); rewrite <- Heq.
    apply red_app1; eassumption.
  - apply (progress_open HRS) in HR₁.
    destruct HR₁ as [ E₂ [ v₂ [ Hred₂ [ HE Hv ] ] ] ].
    intros E₁' z u₁ Heq; symmetry in Heq.
    apply (open_stuck_unique _ (ectx_app1 _ _)) in Heq.
    destruct Heq as [ ? [ ? ? ] ]; subst.
    exists (ectx_app1 E₂ s₂); exists v₂; split; [ | split ].
    * simpl; apply red_rtc_app1; assumption.
    * unfold ectx_rel; left; right.
      simpl; constructor; [ apply Mk_map_id; exact HE | ].
      constructor; apply (progress_sub_active HRS); assumption.
    * right; right; right; right; assumption.
Qed.

Lemma app_evolution : app ↝ app & app_act.
Proof.
intros R S HRS; split.
+ apply app_passive_evolution.
+ apply app_active_evolution; assumption.
Qed.