Require Import Utf8.
Require Import Lang LangProperties.

Inductive class {V : Set} : term V → Set :=
| cl_value : ∀ v : value V, class v
| cl_red   : ∀ t t' : term V, red t t' → class t
| cl_open  : ∀ (E : ectx V) (x : V) (v : value V),
    class (E $[ tm_app (val_var x) v ])
.

Fixpoint classify {V : Set} (t : term V) : class t.
Proof.
destruct t as [ v | t s ].
+ apply cl_value.
+ destruct (classify _ t) as [ v | t t' | E x v ].
  - destruct (classify _ s) as [ w | s s' | E x w ].
    * { destruct v as [ x | t ].
      + apply (cl_open ectx_mt).
      + eapply cl_red; constructor 1.
      }
    * eapply cl_red; constructor 3; eassumption.
    * apply (cl_open (ectx_app2 _ E)).
  - eapply cl_red; constructor 2; eassumption.
  - apply (cl_open (ectx_app1 E _)).
Defined.

Lemma red_in_ectx {V : Set} (E : ectx V) (t t' : term V) :
  red t t' → red (E $[ t ]) (E $[ t' ]).
Proof.
intro Hred; induction E as [ | E IHE s | v E IHE ]; simpl.
+ assumption.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
Qed.

Lemma red_rtc_in_ectx {V : Set} (E : ectx V) (t t' : term V) :
  red_rtc t t' → red_rtc (E $[ t ]) (E $[ t' ]).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_in_ectx; eassumption.
+ assumption.
Qed.

Lemma open_is_stuck {V : Set} (E : ectx V) (x : V) (v : value V) t :
  red (E $[ tm_app (val_var x) v ]) t → False.
Proof.
generalize t; clear t.
induction E as [ | E IHE s | w E IHE ]; intro t; simpl.
+ intro H; inversion H; subst; clear H;
  match goal with [ H : red _ _ |- _ ] => inversion H end.
+ intro H; inversion H; subst; clear H;
    try (destruct E; discriminate; fail).
  eapply IHE; eassumption.
+ intro H; inversion H; subst; clear H.
  - destruct E; discriminate.
  - match goal with [ H : red _ _ |- _ ] => inversion H end.
  - eapply IHE; eassumption.
Qed.

Lemma open_stuck_unique {V : Set}
  (E₁ E₂ : ectx V) (x₁ x₂ : V) (v₁ v₂ : value V) :
  E₁ $[ tm_app (val_var x₁) v₁ ] = E₂ $[ tm_app (val_var x₂) v₂ ] →
  E₁ = E₂ ∧ x₁ = x₂ ∧ v₁ = v₂.
Proof.
generalize E₂; clear E₂; induction E₁ as [ | E₁ IHE t₁ | w₁ E₁ IHE ];
  simpl; intros E₂ Heq.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - injection Heq; clear Heq; auto.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₂; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₂; discriminate.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₁; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHE in Heq₂.
    repeat match goal with [ H : _ ∧ _ |- _ ] => destruct H end.
    subst; auto.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₁; discriminate.
+ destruct E₂ as [ | E₂ ? | ? E₂ ]; simpl in Heq.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₁; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    destruct E₂; discriminate.
  - injection Heq; clear Heq; intros Heq₁ Heq₂.
    apply IHE in Heq₁.
    repeat match goal with [ H : _ ∧ _ |- _ ] => destruct H end.
    subst; auto.
Qed.

Lemma red_rtc_trans {V : Set} (t₁ t₂ t₃ : term V) :
  red_rtc t₁ t₂ → red_rtc t₂ t₃ → red_rtc t₁ t₃.
Proof.
induction 1 as [ | t₁ t₁' t₂ Hred Hrtc1 IH ]; [ auto | ].
intro Hrtc2; econstructor; eauto.
Qed.

Lemma red_rtc_app1 {V : Set} (t t' s : term V) :
  red_rtc t t' → red_rtc (tm_app t s) (tm_app t' s).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_app1; eassumption.
+ assumption.
Qed.

Lemma red_rtc_app2 {V : Set} (v : value V) (t t' : term V) :
  red_rtc t t' → red_rtc (tm_app v t) (tm_app v t').
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_app2; eassumption.
+ assumption.
Qed.

Lemma red_beta' {V : Set} (t : term (inc V)) (v : value V) (t' : term V) :
  t {t↦ v} = t' → red (tm_app (val_lam t) v) t'.
Proof.
intro H; rewrite <- H; constructor.
Qed.

Lemma red_map {A B : Set} (t t' : term A) (f : A → B) :
  red t t' → red (tmap f t) (tmap f t').
Proof.
induction 1 as [ t w | t t' s | w t t' ]; simpl.
+ apply red_beta', tmonad_bind_map.
  intros [ | x ]; reflexivity.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
Qed.

Lemma red_rtc_map {A B : Set} (t t' : term A) (f : A → B) :
  red_rtc t t' → red_rtc (tmap f t) (tmap f t').
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_map; eassumption.
+ assumption.
Qed.

Lemma red_subst {V : Set} (t t' : term (inc V)) (v : value V) :
  red t t' → red (t {t↦ v}) (t' {t↦ v}).
Proof.
induction 1 as [ t w | t t' s | w t t' ]; simpl.
+ apply red_beta', tmonad_bind_bind.
  intros [ | [ | x ] ]; simpl; try reflexivity.
  apply subst_vshift.
+ apply red_app1; assumption.
+ apply red_app2; assumption.
Qed.

Lemma red_rtc_subst {V : Set} (t t' : term (inc V)) (v : value V) :
  red_rtc t t' → red_rtc (t {t↦ v}) (t' {t↦ v}).
Proof.
induction 1; [ constructor 1 | econstructor 2 ].
+ apply red_subst; eassumption.
+ assumption.
Qed.

Lemma red_determ {V : Set} (t t₁ t₂ : term V) :
  red t t₁ → red t t₂ → t₁ = t₂.
Proof.
intro Hred; generalize t₂; clear t₂.
induction Hred; intros t₂ Hred2.
+ inversion Hred2; try reflexivity;
  match goal with [ H : red (tm_val _) _ |- _ ] => inversion H end.
+ inversion Hred2; subst;
    try match goal with
    [ H : red (tm_val _) _ |- _ ] => inversion H; fail
    end.
  erewrite IHHred; [ reflexivity | eassumption ].
+ inversion Hred2; subst;
    try match goal with
    [ H : red (tm_val _) _ |- _ ] => inversion H; fail
    end.
  erewrite IHHred; [ reflexivity | eassumption ].
Qed.

Lemma red_app2_determ {V : Set} (v : value V) (t₁ t₂ t : term V) :
  red t₁ t₂ → red (tm_app v t₁) t → t = tm_app v t₂.
Proof.
intros Hred1 Hred2.
inversion Hred2; subst.
+ inversion Hred1.
+ match goal with [ H : red (tm_val _) _ |- _ ] => inversion H end.
+ erewrite (red_determ _ _ _ Hred1); [ reflexivity | ]; assumption.
Qed.

Lemma red_eplug_app {V : Set} (E : ectx V) (t s r : term V) :
  red (E $[ tm_app t s ]) r → ∃ r', r = E $[ r' ] ∧ red (tm_app t s) r'.
Proof.
generalize r; clear r.
induction E as [ | E IHE s' | v E IHE ]; simpl; intros r Hred.
+ exists r; split; [ reflexivity | assumption ].
+ inversion Hred as [ | ? ? ? Hred' | ]; subst; clear Hred.
  - destruct E; discriminate.
  - apply IHE in Hred'; destruct Hred' as [ r' [ Heq Hred' ] ].
    subst; eexists; split; [ reflexivity | assumption ].
  - destruct E; discriminate.
+ inversion Hred as [ | ? ? ? Hred' | ? ? ? Hred' ]; subst; clear Hred.
  - destruct E; discriminate.
  - inversion Hred'.
  - apply IHE in Hred'; destruct Hred' as [ r' [ Heq Hred' ] ].
    subst; eexists; split; [ reflexivity | assumption ].
Qed.